<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FarebasisChangesParameter StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFarebasisChangesParameter extends AbstractStructBase
{
    /**
     * The SegmentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentRef;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasis;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassengerType;
    /**
     * Constructor method for FarebasisChangesParameter
     * @uses DgFarebasisChangesParameter::setSegmentRef()
     * @uses DgFarebasisChangesParameter::setFareBasis()
     * @uses DgFarebasisChangesParameter::setPassengerType()
     * @param string $segmentRef
     * @param string $fareBasis
     * @param string $passengerType
     */
    public function __construct($segmentRef = null, $fareBasis = null, $passengerType = null)
    {
        $this
            ->setSegmentRef($segmentRef)
            ->setFareBasis($fareBasis)
            ->setPassengerType($passengerType);
    }
    /**
     * Get SegmentRef value
     * @return string|null
     */
    public function getSegmentRef()
    {
        return $this->SegmentRef;
    }
    /**
     * Set SegmentRef value
     * @param string $segmentRef
     * @return \dgsoft\StructType\DgFarebasisChangesParameter
     */
    public function setSegmentRef($segmentRef = null)
    {
        // validation for constraint: string
        if (!is_null($segmentRef) && !is_string($segmentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentRef)), __LINE__);
        }
        $this->SegmentRef = $segmentRef;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return string|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param string $fareBasis
     * @return \dgsoft\StructType\DgFarebasisChangesParameter
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasis)), __LINE__);
        }
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgFarebasisChangesParameter
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFarebasisChangesParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
