<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRuleResponseInfoTypeRouting StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareRuleResponseInfoTypeRouting extends AbstractStructBase
{
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo[]
     */
    public $Info;
    /**
     * The Number
     * @var int
     */
    public $Number;
    /**
     * The RoutingConstructedInd
     * @var bool
     */
    public $RoutingConstructedInd;
    /**
     * The MaximumPermittedMileage
     * @var int
     */
    public $MaximumPermittedMileage;
    /**
     * The RoutingRestriction
     * @var string
     */
    public $RoutingRestriction;
    /**
     * Constructor method for FareRuleResponseInfoTypeRouting
     * @uses DgFareRuleResponseInfoTypeRouting::setInfo()
     * @uses DgFareRuleResponseInfoTypeRouting::setNumber()
     * @uses DgFareRuleResponseInfoTypeRouting::setRoutingConstructedInd()
     * @uses DgFareRuleResponseInfoTypeRouting::setMaximumPermittedMileage()
     * @uses DgFareRuleResponseInfoTypeRouting::setRoutingRestriction()
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo[] $info
     * @param int $number
     * @param bool $routingConstructedInd
     * @param int $maximumPermittedMileage
     * @param string $routingRestriction
     */
    public function __construct(array $info = array(), $number = null, $routingConstructedInd = null, $maximumPermittedMileage = null, $routingRestriction = null)
    {
        $this
            ->setInfo($info)
            ->setNumber($number)
            ->setRoutingConstructedInd($routingConstructedInd)
            ->setMaximumPermittedMileage($maximumPermittedMileage)
            ->setRoutingRestriction($routingRestriction);
    }
    /**
     * Get Info value
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo[]|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo[] $info
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $fareRuleResponseInfoTypeRoutingInfoItem) {
            // validation for constraint: itemType
            if (!$fareRuleResponseInfoTypeRoutingInfoItem instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo) {
                throw new \InvalidArgumentException(sprintf('The Info property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo, "%s" given', is_object($fareRuleResponseInfoTypeRoutingInfoItem) ? get_class($fareRuleResponseInfoTypeRoutingInfoItem) : gettype($fareRuleResponseInfoTypeRoutingInfoItem)), __LINE__);
            }
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Add item to Info value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo $item
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public function addToInfo(\dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo) {
            throw new \InvalidArgumentException(sprintf('The Info property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeRoutingInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Info[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get RoutingConstructedInd value
     * @return bool|null
     */
    public function getRoutingConstructedInd()
    {
        return $this->RoutingConstructedInd;
    }
    /**
     * Set RoutingConstructedInd value
     * @param bool $routingConstructedInd
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public function setRoutingConstructedInd($routingConstructedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($routingConstructedInd) && !is_bool($routingConstructedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($routingConstructedInd)), __LINE__);
        }
        $this->RoutingConstructedInd = $routingConstructedInd;
        return $this;
    }
    /**
     * Get MaximumPermittedMileage value
     * @return int|null
     */
    public function getMaximumPermittedMileage()
    {
        return $this->MaximumPermittedMileage;
    }
    /**
     * Set MaximumPermittedMileage value
     * @param int $maximumPermittedMileage
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public function setMaximumPermittedMileage($maximumPermittedMileage = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPermittedMileage) && !is_numeric($maximumPermittedMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumPermittedMileage)), __LINE__);
        }
        $this->MaximumPermittedMileage = $maximumPermittedMileage;
        return $this;
    }
    /**
     * Get RoutingRestriction value
     * @return string|null
     */
    public function getRoutingRestriction()
    {
        return $this->RoutingRestriction;
    }
    /**
     * Set RoutingRestriction value
     * @param string $routingRestriction
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public function setRoutingRestriction($routingRestriction = null)
    {
        // validation for constraint: string
        if (!is_null($routingRestriction) && !is_string($routingRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingRestriction)), __LINE__);
        }
        $this->RoutingRestriction = $routingRestriction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
