<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareInfo extends DgFareInfoType
{
    /**
     * The PassengerFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareType
     */
    public $PassengerFare;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDate[]
     */
    public $Date;
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFare
     */
    public $Fare;
    /**
     * The PTC
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPTC[]
     */
    public $PTC;
    /**
     * The FareBasisCode
     * @var string
     */
    public $FareBasisCode;
    /**
     * The GlobalIndicatorCode
     * @var string
     */
    public $GlobalIndicatorCode;
    /**
     * The MaximumPermittedMileage
     * @var int
     */
    public $MaximumPermittedMileage;
    /**
     * The TripType
     * @var string
     */
    public $TripType;
    /**
     * The FareType
     * @var string
     */
    public $FareType;
    /**
     * The FareStatus
     * @var string
     */
    public $FareStatus;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ExtraFare
     * @var string
     */
    public $ExtraFare;
    /**
     * The ServiceFee
     * @var string
     */
    public $ServiceFee;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for FareInfo
     * @uses DgFareInfo::setPassengerFare()
     * @uses DgFareInfo::setDate()
     * @uses DgFareInfo::setFare()
     * @uses DgFareInfo::setPTC()
     * @uses DgFareInfo::setFareBasisCode()
     * @uses DgFareInfo::setGlobalIndicatorCode()
     * @uses DgFareInfo::setMaximumPermittedMileage()
     * @uses DgFareInfo::setTripType()
     * @uses DgFareInfo::setFareType()
     * @uses DgFareInfo::setFareStatus()
     * @uses DgFareInfo::setTPA_Extensions()
     * @uses DgFareInfo::setExtraFare()
     * @uses DgFareInfo::setServiceFee()
     * @uses DgFareInfo::setCurrency()
     * @param \dgsoft\StructType\DgFareType $passengerFare
     * @param \dgsoft\StructType\DgDate[] $date
     * @param \dgsoft\StructType\DgFare $fare
     * @param \dgsoft\StructType\DgPTC[] $pTC
     * @param string $fareBasisCode
     * @param string $globalIndicatorCode
     * @param int $maximumPermittedMileage
     * @param string $tripType
     * @param string $fareType
     * @param string $fareStatus
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $extraFare
     * @param string $serviceFee
     * @param string $currency
     */
    public function __construct(\dgsoft\StructType\DgFareType $passengerFare = null, array $date = array(), \dgsoft\StructType\DgFare $fare = null, array $pTC = array(), $fareBasisCode = null, $globalIndicatorCode = null, $maximumPermittedMileage = null, $tripType = null, $fareType = null, $fareStatus = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $extraFare = null, $serviceFee = null, $currency = null)
    {
        $this
            ->setPassengerFare($passengerFare)
            ->setDate($date)
            ->setFare($fare)
            ->setPTC($pTC)
            ->setFareBasisCode($fareBasisCode)
            ->setGlobalIndicatorCode($globalIndicatorCode)
            ->setMaximumPermittedMileage($maximumPermittedMileage)
            ->setTripType($tripType)
            ->setFareType($fareType)
            ->setFareStatus($fareStatus)
            ->setTPA_Extensions($tPA_Extensions)
            ->setExtraFare($extraFare)
            ->setServiceFee($serviceFee)
            ->setCurrency($currency);
    }
    /**
     * Get PassengerFare value
     * @return \dgsoft\StructType\DgFareType|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param \dgsoft\StructType\DgFareType $passengerFare
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setPassengerFare(\dgsoft\StructType\DgFareType $passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Get Date value
     * @return \dgsoft\StructType\DgDate[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDate[] $date
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $fareInfoDateItem) {
            // validation for constraint: itemType
            if (!$fareInfoDateItem instanceof \dgsoft\StructType\DgDate) {
                throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \dgsoft\StructType\DgDate, "%s" given', is_object($fareInfoDateItem) ? get_class($fareInfoDateItem) : gettype($fareInfoDateItem)), __LINE__);
            }
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDate $item
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function addToDate(\dgsoft\StructType\DgDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDate) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \dgsoft\StructType\DgDate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get Fare value
     * @return \dgsoft\StructType\DgFare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \dgsoft\StructType\DgFare $fare
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setFare(\dgsoft\StructType\DgFare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get PTC value
     * @return \dgsoft\StructType\DgPTC[]|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * Set PTC value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPTC[] $pTC
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setPTC(array $pTC = array())
    {
        foreach ($pTC as $fareInfoPTCItem) {
            // validation for constraint: itemType
            if (!$fareInfoPTCItem instanceof \dgsoft\StructType\DgPTC) {
                throw new \InvalidArgumentException(sprintf('The PTC property can only contain items of \dgsoft\StructType\DgPTC, "%s" given', is_object($fareInfoPTCItem) ? get_class($fareInfoPTCItem) : gettype($fareInfoPTCItem)), __LINE__);
            }
        }
        $this->PTC = $pTC;
        return $this;
    }
    /**
     * Add item to PTC value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPTC $item
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function addToPTC(\dgsoft\StructType\DgPTC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPTC) {
            throw new \InvalidArgumentException(sprintf('The PTC property can only contain items of \dgsoft\StructType\DgPTC, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PTC[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get GlobalIndicatorCode value
     * @return string|null
     */
    public function getGlobalIndicatorCode()
    {
        return $this->GlobalIndicatorCode;
    }
    /**
     * Set GlobalIndicatorCode value
     * @uses \dgsoft\EnumType\DgGlobalIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgGlobalIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalIndicatorCode
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setGlobalIndicatorCode($globalIndicatorCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgGlobalIndicatorType::valueIsValid($globalIndicatorCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $globalIndicatorCode, implode(', ', \dgsoft\EnumType\DgGlobalIndicatorType::getValidValues())), __LINE__);
        }
        $this->GlobalIndicatorCode = $globalIndicatorCode;
        return $this;
    }
    /**
     * Get MaximumPermittedMileage value
     * @return int|null
     */
    public function getMaximumPermittedMileage()
    {
        return $this->MaximumPermittedMileage;
    }
    /**
     * Set MaximumPermittedMileage value
     * @param int $maximumPermittedMileage
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setMaximumPermittedMileage($maximumPermittedMileage = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPermittedMileage) && !is_numeric($maximumPermittedMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumPermittedMileage)), __LINE__);
        }
        $this->MaximumPermittedMileage = $maximumPermittedMileage;
        return $this;
    }
    /**
     * Get TripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @uses \dgsoft\EnumType\DgAirTripType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripType
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAirTripType::valueIsValid($tripType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tripType, implode(', ', \dgsoft\EnumType\DgAirTripType::getValidValues())), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @uses \dgsoft\EnumType\DgFareStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgFareStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareStatus
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setFareStatus($fareStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgFareStatusType::valueIsValid($fareStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fareStatus, implode(', ', \dgsoft\EnumType\DgFareStatusType::getValidValues())), __LINE__);
        }
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ExtraFare value
     * @return string|null
     */
    public function getExtraFare()
    {
        return $this->ExtraFare;
    }
    /**
     * Set ExtraFare value
     * @param string $extraFare
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setExtraFare($extraFare = null)
    {
        // validation for constraint: string
        if (!is_null($extraFare) && !is_string($extraFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extraFare)), __LINE__);
        }
        $this->ExtraFare = $extraFare;
        return $this;
    }
    /**
     * Get ServiceFee value
     * @return string|null
     */
    public function getServiceFee()
    {
        return $this->ServiceFee;
    }
    /**
     * Set ServiceFee value
     * @param string $serviceFee
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setServiceFee($serviceFee = null)
    {
        // validation for constraint: string
        if (!is_null($serviceFee) && !is_string($serviceFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceFee)), __LINE__);
        }
        $this->ServiceFee = $serviceFee;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgFareInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
