<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareComponent extends AbstractStructBase
{
    /**
     * The FlightLeg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightLeg[]
     */
    public $FlightLeg;
    /**
     * The Number
     * @var int
     */
    public $Number;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for FareComponent
     * @uses DgFareComponent::setFlightLeg()
     * @uses DgFareComponent::setNumber()
     * @uses DgFareComponent::setAmount()
     * @param \dgsoft\StructType\DgFlightLeg[] $flightLeg
     * @param int $number
     * @param float $amount
     */
    public function __construct(array $flightLeg = array(), $number = null, $amount = null)
    {
        $this
            ->setFlightLeg($flightLeg)
            ->setNumber($number)
            ->setAmount($amount);
    }
    /**
     * Get FlightLeg value
     * @return \dgsoft\StructType\DgFlightLeg[]|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * Set FlightLeg value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightLeg[] $flightLeg
     * @return \dgsoft\StructType\DgFareComponent
     */
    public function setFlightLeg(array $flightLeg = array())
    {
        foreach ($flightLeg as $fareComponentFlightLegItem) {
            // validation for constraint: itemType
            if (!$fareComponentFlightLegItem instanceof \dgsoft\StructType\DgFlightLeg) {
                throw new \InvalidArgumentException(sprintf('The FlightLeg property can only contain items of \dgsoft\StructType\DgFlightLeg, "%s" given', is_object($fareComponentFlightLegItem) ? get_class($fareComponentFlightLegItem) : gettype($fareComponentFlightLegItem)), __LINE__);
            }
        }
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Add item to FlightLeg value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightLeg $item
     * @return \dgsoft\StructType\DgFareComponent
     */
    public function addToFlightLeg(\dgsoft\StructType\DgFlightLeg $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFlightLeg) {
            throw new \InvalidArgumentException(sprintf('The FlightLeg property can only contain items of \dgsoft\StructType\DgFlightLeg, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightLeg[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \dgsoft\StructType\DgFareComponent
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgFareComponent
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
