<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FailbackRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFailbackRS extends AbstractStructBase
{
    /**
     * The NewPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $NewPrice;
    /**
     * The FreeBaggageAllowance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeBaggageAllowancesTypes
     */
    public $FreeBaggageAllowance;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightSegment[]
     */
    public $FlightSegment;
    /**
     * The FailbackIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFailbackIndicator[]
     */
    public $FailbackIndicator;
    /**
     * Constructor method for FailbackRS
     * @uses DgFailbackRS::setNewPrice()
     * @uses DgFailbackRS::setFreeBaggageAllowance()
     * @uses DgFailbackRS::setFlightSegment()
     * @uses DgFailbackRS::setFailbackIndicator()
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice
     * @param \dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance
     * @param \dgsoft\StructType\DgFlightSegment[] $flightSegment
     * @param \dgsoft\StructType\DgFailbackIndicator[] $failbackIndicator
     */
    public function __construct(\dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice = null, \dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance = null, array $flightSegment = array(), array $failbackIndicator = array())
    {
        $this
            ->setNewPrice($newPrice)
            ->setFreeBaggageAllowance($freeBaggageAllowance)
            ->setFlightSegment($flightSegment)
            ->setFailbackIndicator($failbackIndicator);
    }
    /**
     * Get NewPrice value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public function setNewPrice(\dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice = null)
    {
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get FreeBaggageAllowance value
     * @return \dgsoft\StructType\DgFreeBaggageAllowancesTypes|null
     */
    public function getFreeBaggageAllowance()
    {
        return $this->FreeBaggageAllowance;
    }
    /**
     * Set FreeBaggageAllowance value
     * @param \dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public function setFreeBaggageAllowance(\dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance = null)
    {
        $this->FreeBaggageAllowance = $freeBaggageAllowance;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \dgsoft\StructType\DgFlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightSegment[] $flightSegment
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        foreach ($flightSegment as $failbackRSFlightSegmentItem) {
            // validation for constraint: itemType
            if (!$failbackRSFlightSegmentItem instanceof \dgsoft\StructType\DgFlightSegment) {
                throw new \InvalidArgumentException(sprintf('The FlightSegment property can only contain items of \dgsoft\StructType\DgFlightSegment, "%s" given', is_object($failbackRSFlightSegmentItem) ? get_class($failbackRSFlightSegmentItem) : gettype($failbackRSFlightSegmentItem)), __LINE__);
            }
        }
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightSegment $item
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public function addToFlightSegment(\dgsoft\StructType\DgFlightSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFlightSegment) {
            throw new \InvalidArgumentException(sprintf('The FlightSegment property can only contain items of \dgsoft\StructType\DgFlightSegment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get FailbackIndicator value
     * @return \dgsoft\StructType\DgFailbackIndicator[]|null
     */
    public function getFailbackIndicator()
    {
        return $this->FailbackIndicator;
    }
    /**
     * Set FailbackIndicator value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFailbackIndicator[] $failbackIndicator
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public function setFailbackIndicator(array $failbackIndicator = array())
    {
        foreach ($failbackIndicator as $failbackRSFailbackIndicatorItem) {
            // validation for constraint: itemType
            if (!$failbackRSFailbackIndicatorItem instanceof \dgsoft\StructType\DgFailbackIndicator) {
                throw new \InvalidArgumentException(sprintf('The FailbackIndicator property can only contain items of \dgsoft\StructType\DgFailbackIndicator, "%s" given', is_object($failbackRSFailbackIndicatorItem) ? get_class($failbackRSFailbackIndicatorItem) : gettype($failbackRSFailbackIndicatorItem)), __LINE__);
            }
        }
        $this->FailbackIndicator = $failbackIndicator;
        return $this;
    }
    /**
     * Add item to FailbackIndicator value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFailbackIndicator $item
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public function addToFailbackIndicator(\dgsoft\StructType\DgFailbackIndicator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFailbackIndicator) {
            throw new \InvalidArgumentException(sprintf('The FailbackIndicator property can only contain items of \dgsoft\StructType\DgFailbackIndicator, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FailbackIndicator[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFailbackRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
