<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpandedParametersType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgExpandedParametersType extends AbstractStructBase
{
    /**
     * The Param
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Param;
    /**
     * Constructor method for ExpandedParametersType
     * @uses DgExpandedParametersType::setParam()
     * @param string[] $param
     */
    public function __construct(array $param = array())
    {
        $this
            ->setParam($param);
    }
    /**
     * Get Param value
     * @return string[]|null
     */
    public function getParam()
    {
        return $this->Param;
    }
    /**
     * Set Param value
     * @uses \dgsoft\EnumType\DgExpandedParameterEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgExpandedParameterEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $param
     * @return \dgsoft\StructType\DgExpandedParametersType
     */
    public function setParam(array $param = array())
    {
        $invalidValues = array();
        foreach ($param as $expandedParametersTypeParamItem) {
            if (!\dgsoft\EnumType\DgExpandedParameterEnum::valueIsValid($expandedParametersTypeParamItem)) {
                $invalidValues[] = var_export($expandedParametersTypeParamItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgExpandedParameterEnum::getValidValues())), __LINE__);
        }
        $this->Param = $param;
        return $this;
    }
    /**
     * Add item to Param value
     * @uses \dgsoft\EnumType\DgExpandedParameterEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgExpandedParameterEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgExpandedParametersType
     */
    public function addToParam($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgExpandedParameterEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgExpandedParameterEnum::getValidValues())), __LINE__);
        }
        $this->Param[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgExpandedParametersType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
