<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgErrorType extends DgFreeTextType
{
    /**
     * The BreakFlow
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $BreakFlow;
    /**
     * The _
     * @var \dgsoft\StructType\DgFreeTextType
     */
    public $_;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The ErrorCode
     * @var string
     */
    public $ErrorCode;
    /**
     * The ShortText
     * @var string
     */
    public $ShortText;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The DocURL
     * @var string
     */
    public $DocURL;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The Tag
     * @var string
     */
    public $Tag;
    /**
     * The RecordID
     * @var string
     */
    public $RecordID;
    /**
     * The NodeList
     * @var string
     */
    public $NodeList;
    /**
     * Constructor method for ErrorType
     * @uses DgErrorType::setBreakFlow()
     * @uses DgErrorType::set_()
     * @uses DgErrorType::setType()
     * @uses DgErrorType::setErrorCode()
     * @uses DgErrorType::setShortText()
     * @uses DgErrorType::setCode()
     * @uses DgErrorType::setDocURL()
     * @uses DgErrorType::setStatus()
     * @uses DgErrorType::setTag()
     * @uses DgErrorType::setRecordID()
     * @uses DgErrorType::setNodeList()
     * @param bool $breakFlow
     * @param \dgsoft\StructType\DgFreeTextType $_
     * @param string $type
     * @param string $errorCode
     * @param string $shortText
     * @param string $code
     * @param string $docURL
     * @param string $status
     * @param string $tag
     * @param string $recordID
     * @param string $nodeList
     */
    public function __construct($breakFlow = null, \dgsoft\StructType\DgFreeTextType $_ = null, $type = null, $errorCode = null, $shortText = null, $code = null, $docURL = null, $status = null, $tag = null, $recordID = null, $nodeList = null)
    {
        $this
            ->setBreakFlow($breakFlow)
            ->set_($_)
            ->setType($type)
            ->setErrorCode($errorCode)
            ->setShortText($shortText)
            ->setCode($code)
            ->setDocURL($docURL)
            ->setStatus($status)
            ->setTag($tag)
            ->setRecordID($recordID)
            ->setNodeList($nodeList);
    }
    /**
     * Get BreakFlow value
     * @return bool
     */
    public function getBreakFlow()
    {
        return $this->BreakFlow;
    }
    /**
     * Set BreakFlow value
     * @param bool $breakFlow
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setBreakFlow($breakFlow = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakFlow) && !is_bool($breakFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($breakFlow)), __LINE__);
        }
        $this->BreakFlow = $breakFlow;
        return $this;
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgFreeTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgFreeTextType $_
     * @return \dgsoft\StructType\DgErrorType
     */
    public function set_(\dgsoft\StructType\DgFreeTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setShortText($shortText = null)
    {
        // validation for constraint: string
        if (!is_null($shortText) && !is_string($shortText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortText)), __LINE__);
        }
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DocURL value
     * @return string|null
     */
    public function getDocURL()
    {
        return $this->DocURL;
    }
    /**
     * Set DocURL value
     * @param string $docURL
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setDocURL($docURL = null)
    {
        // validation for constraint: string
        if (!is_null($docURL) && !is_string($docURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docURL)), __LINE__);
        }
        $this->DocURL = $docURL;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param string $tag
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tag)), __LINE__);
        }
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get NodeList value
     * @return string|null
     */
    public function getNodeList()
    {
        return $this->NodeList;
    }
    /**
     * Set NodeList value
     * @param string $nodeList
     * @return \dgsoft\StructType\DgErrorType
     */
    public function setNodeList($nodeList = null)
    {
        // validation for constraint: string
        if (!is_null($nodeList) && !is_string($nodeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nodeList)), __LINE__);
        }
        $this->NodeList = $nodeList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgErrorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
