<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentTypePref StructType
 * @package Dg
 * @subpackage Structs
 */
class DgEquipmentTypePref extends DgEquipmentType
{
    /**
     * The _
     * @var \dgsoft\StructType\DgEquipmentType
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The WideBody
     * @var bool
     */
    public $WideBody;
    /**
     * Constructor method for EquipmentTypePref
     * @uses DgEquipmentTypePref::set_()
     * @uses DgEquipmentTypePref::setPreferLevel()
     * @uses DgEquipmentTypePref::setWideBody()
     * @param \dgsoft\StructType\DgEquipmentType $_
     * @param string $preferLevel
     * @param bool $wideBody
     */
    public function __construct(\dgsoft\StructType\DgEquipmentType $_ = null, $preferLevel = 'Preferred', $wideBody = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setWideBody($wideBody);
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgEquipmentType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgEquipmentType $_
     * @return \dgsoft\StructType\DgEquipmentTypePref
     */
    public function set_(\dgsoft\StructType\DgEquipmentType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgEquipmentTypePref
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get WideBody value
     * @return bool|null
     */
    public function getWideBody()
    {
        return $this->WideBody;
    }
    /**
     * Set WideBody value
     * @param bool $wideBody
     * @return \dgsoft\StructType\DgEquipmentTypePref
     */
    public function setWideBody($wideBody = null)
    {
        // validation for constraint: boolean
        if (!is_null($wideBody) && !is_bool($wideBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($wideBody)), __LINE__);
        }
        $this->WideBody = $wideBody;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgEquipmentTypePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
