<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endorsements StructType
 * @package Dg
 * @subpackage Structs
 */
class DgEndorsements extends AbstractStructBase
{
    /**
     * The Endorsement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEndorsement[]
     */
    public $Endorsement;
    /**
     * The NonRefundableIndicator
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * The NonEndorsableIndicator
     * @var bool
     */
    public $NonEndorsableIndicator;
    /**
     * Constructor method for Endorsements
     * @uses DgEndorsements::setEndorsement()
     * @uses DgEndorsements::setNonRefundableIndicator()
     * @uses DgEndorsements::setNonEndorsableIndicator()
     * @param \dgsoft\StructType\DgEndorsement[] $endorsement
     * @param bool $nonRefundableIndicator
     * @param bool $nonEndorsableIndicator
     */
    public function __construct(array $endorsement = array(), $nonRefundableIndicator = null, $nonEndorsableIndicator = null)
    {
        $this
            ->setEndorsement($endorsement)
            ->setNonRefundableIndicator($nonRefundableIndicator)
            ->setNonEndorsableIndicator($nonEndorsableIndicator);
    }
    /**
     * Get Endorsement value
     * @return \dgsoft\StructType\DgEndorsement[]|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEndorsement[] $endorsement
     * @return \dgsoft\StructType\DgEndorsements
     */
    public function setEndorsement(array $endorsement = array())
    {
        foreach ($endorsement as $endorsementsEndorsementItem) {
            // validation for constraint: itemType
            if (!$endorsementsEndorsementItem instanceof \dgsoft\StructType\DgEndorsement) {
                throw new \InvalidArgumentException(sprintf('The Endorsement property can only contain items of \dgsoft\StructType\DgEndorsement, "%s" given', is_object($endorsementsEndorsementItem) ? get_class($endorsementsEndorsementItem) : gettype($endorsementsEndorsementItem)), __LINE__);
            }
        }
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Add item to Endorsement value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEndorsement $item
     * @return \dgsoft\StructType\DgEndorsements
     */
    public function addToEndorsement(\dgsoft\StructType\DgEndorsement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEndorsement) {
            throw new \InvalidArgumentException(sprintf('The Endorsement property can only contain items of \dgsoft\StructType\DgEndorsement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Endorsement[] = $item;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \dgsoft\StructType\DgEndorsements
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableIndicator) && !is_bool($nonRefundableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRefundableIndicator)), __LINE__);
        }
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Get NonEndorsableIndicator value
     * @return bool|null
     */
    public function getNonEndorsableIndicator()
    {
        return $this->NonEndorsableIndicator;
    }
    /**
     * Set NonEndorsableIndicator value
     * @param bool $nonEndorsableIndicator
     * @return \dgsoft\StructType\DgEndorsements
     */
    public function setNonEndorsableIndicator($nonEndorsableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonEndorsableIndicator) && !is_bool($nonEndorsableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonEndorsableIndicator)), __LINE__);
        }
        $this->NonEndorsableIndicator = $nonEndorsableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgEndorsements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
