<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETicketItineraryInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgETicketItineraryInfo extends AbstractStructBase
{
    /**
     * The FlightNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FlightNo;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The FromTerminal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromTerminal;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To;
    /**
     * The ToTerminal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToTerminal;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier;
    /**
     * The OperatingAirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingAirlineCode;
    /**
     * The MarketingAirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketingAirlineCode;
    /**
     * The Class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Class;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasis;
    /**
     * The NotValidBefore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotValidBefore;
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotValidAfter;
    /**
     * The BaggageWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $BaggageWeight;
    /**
     * The BaggageWeightMeasureUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaggageWeightMeasureUnit;
    /**
     * The BaggageQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $BaggageQuantity;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for ETicketItineraryInfo
     * @uses DgETicketItineraryInfo::setFlightNo()
     * @uses DgETicketItineraryInfo::setDepartureDate()
     * @uses DgETicketItineraryInfo::setArrivalDate()
     * @uses DgETicketItineraryInfo::setFrom()
     * @uses DgETicketItineraryInfo::setFromTerminal()
     * @uses DgETicketItineraryInfo::setTo()
     * @uses DgETicketItineraryInfo::setToTerminal()
     * @uses DgETicketItineraryInfo::setCarrier()
     * @uses DgETicketItineraryInfo::setOperatingAirlineCode()
     * @uses DgETicketItineraryInfo::setMarketingAirlineCode()
     * @uses DgETicketItineraryInfo::setClass()
     * @uses DgETicketItineraryInfo::setFareBasis()
     * @uses DgETicketItineraryInfo::setNotValidBefore()
     * @uses DgETicketItineraryInfo::setNotValidAfter()
     * @uses DgETicketItineraryInfo::setBaggageWeight()
     * @uses DgETicketItineraryInfo::setBaggageWeightMeasureUnit()
     * @uses DgETicketItineraryInfo::setBaggageQuantity()
     * @uses DgETicketItineraryInfo::setStatus()
     * @param int $flightNo
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $from
     * @param string $fromTerminal
     * @param string $to
     * @param string $toTerminal
     * @param string $carrier
     * @param string $operatingAirlineCode
     * @param string $marketingAirlineCode
     * @param string $class
     * @param string $fareBasis
     * @param string $notValidBefore
     * @param string $notValidAfter
     * @param float $baggageWeight
     * @param string $baggageWeightMeasureUnit
     * @param float $baggageQuantity
     * @param string $status
     */
    public function __construct($flightNo = null, $departureDate = null, $arrivalDate = null, $from = null, $fromTerminal = null, $to = null, $toTerminal = null, $carrier = null, $operatingAirlineCode = null, $marketingAirlineCode = null, $class = null, $fareBasis = null, $notValidBefore = null, $notValidAfter = null, $baggageWeight = null, $baggageWeightMeasureUnit = null, $baggageQuantity = null, $status = null)
    {
        $this
            ->setFlightNo($flightNo)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setFrom($from)
            ->setFromTerminal($fromTerminal)
            ->setTo($to)
            ->setToTerminal($toTerminal)
            ->setCarrier($carrier)
            ->setOperatingAirlineCode($operatingAirlineCode)
            ->setMarketingAirlineCode($marketingAirlineCode)
            ->setClass($class)
            ->setFareBasis($fareBasis)
            ->setNotValidBefore($notValidBefore)
            ->setNotValidAfter($notValidAfter)
            ->setBaggageWeight($baggageWeight)
            ->setBaggageWeightMeasureUnit($baggageWeightMeasureUnit)
            ->setBaggageQuantity($baggageQuantity)
            ->setStatus($status);
    }
    /**
     * Get FlightNo value
     * @return int
     */
    public function getFlightNo()
    {
        return $this->FlightNo;
    }
    /**
     * Set FlightNo value
     * @param int $flightNo
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setFlightNo($flightNo = null)
    {
        // validation for constraint: int
        if (!is_null($flightNo) && !is_numeric($flightNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flightNo)), __LINE__);
        }
        $this->FlightNo = $flightNo;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get FromTerminal value
     * @return string|null
     */
    public function getFromTerminal()
    {
        return $this->FromTerminal;
    }
    /**
     * Set FromTerminal value
     * @param string $fromTerminal
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setFromTerminal($fromTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($fromTerminal) && !is_string($fromTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromTerminal)), __LINE__);
        }
        $this->FromTerminal = $fromTerminal;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get ToTerminal value
     * @return string|null
     */
    public function getToTerminal()
    {
        return $this->ToTerminal;
    }
    /**
     * Set ToTerminal value
     * @param string $toTerminal
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setToTerminal($toTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($toTerminal) && !is_string($toTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toTerminal)), __LINE__);
        }
        $this->ToTerminal = $toTerminal;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get OperatingAirlineCode value
     * @return string|null
     */
    public function getOperatingAirlineCode()
    {
        return $this->OperatingAirlineCode;
    }
    /**
     * Set OperatingAirlineCode value
     * @param string $operatingAirlineCode
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setOperatingAirlineCode($operatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAirlineCode) && !is_string($operatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingAirlineCode)), __LINE__);
        }
        $this->OperatingAirlineCode = $operatingAirlineCode;
        return $this;
    }
    /**
     * Get MarketingAirlineCode value
     * @return string|null
     */
    public function getMarketingAirlineCode()
    {
        return $this->MarketingAirlineCode;
    }
    /**
     * Set MarketingAirlineCode value
     * @param string $marketingAirlineCode
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setMarketingAirlineCode($marketingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingAirlineCode) && !is_string($marketingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketingAirlineCode)), __LINE__);
        }
        $this->MarketingAirlineCode = $marketingAirlineCode;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return string|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param string $fareBasis
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasis)), __LINE__);
        }
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get NotValidBefore value
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return $this->NotValidBefore;
    }
    /**
     * Set NotValidBefore value
     * @param string $notValidBefore
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        // validation for constraint: string
        if (!is_null($notValidBefore) && !is_string($notValidBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notValidBefore)), __LINE__);
        }
        $this->NotValidBefore = $notValidBefore;
        return $this;
    }
    /**
     * Get NotValidAfter value
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return $this->NotValidAfter;
    }
    /**
     * Set NotValidAfter value
     * @param string $notValidAfter
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        // validation for constraint: string
        if (!is_null($notValidAfter) && !is_string($notValidAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notValidAfter)), __LINE__);
        }
        $this->NotValidAfter = $notValidAfter;
        return $this;
    }
    /**
     * Get BaggageWeight value
     * @return float|null
     */
    public function getBaggageWeight()
    {
        return $this->BaggageWeight;
    }
    /**
     * Set BaggageWeight value
     * @param float $baggageWeight
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setBaggageWeight($baggageWeight = null)
    {
        $this->BaggageWeight = $baggageWeight;
        return $this;
    }
    /**
     * Get BaggageWeightMeasureUnit value
     * @return string|null
     */
    public function getBaggageWeightMeasureUnit()
    {
        return $this->BaggageWeightMeasureUnit;
    }
    /**
     * Set BaggageWeightMeasureUnit value
     * @param string $baggageWeightMeasureUnit
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setBaggageWeightMeasureUnit($baggageWeightMeasureUnit = null)
    {
        // validation for constraint: string
        if (!is_null($baggageWeightMeasureUnit) && !is_string($baggageWeightMeasureUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baggageWeightMeasureUnit)), __LINE__);
        }
        $this->BaggageWeightMeasureUnit = $baggageWeightMeasureUnit;
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return float|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param float $baggageQuantity
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgETicketItineraryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
