<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDocumentType extends AbstractStructBase
{
    /**
     * The DocHolderFormattedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $DocHolderFormattedName;
    /**
     * The DocHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocHolderName;
    /**
     * The DocLimitations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DocLimitations;
    /**
     * The AdditionalPersonNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString1
     */
    public $AdditionalPersonNames;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DocIssueAuthority
     * @var string
     */
    public $DocIssueAuthority;
    /**
     * The DocIssueLocation
     * @var string
     */
    public $DocIssueLocation;
    /**
     * The DocID
     * @var string
     */
    public $DocID;
    /**
     * The DocType
     * @var string
     */
    public $DocType;
    /**
     * The InnerDocType
     * @var string
     */
    public $InnerDocType;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The DocIssueStateProv
     * @var string
     */
    public $DocIssueStateProv;
    /**
     * The DocIssueCountry
     * @var string
     */
    public $DocIssueCountry;
    /**
     * The AddressType
     * @var string
     */
    public $AddressType;
    /**
     * The AddressDetails
     * @var string
     */
    public $AddressDetails;
    /**
     * The CityCode
     * @var string
     */
    public $CityCode;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The ZipPostalCode
     * @var string
     */
    public $ZipPostalCode;
    /**
     * The BirthCountry
     * @var string
     */
    public $BirthCountry;
    /**
     * The DocHolderNationality
     * @var string
     */
    public $DocHolderNationality;
    /**
     * The ContactName
     * @var string
     */
    public $ContactName;
    /**
     * The HolderType
     * @var string
     */
    public $HolderType;
    /**
     * Constructor method for DocumentType
     * @uses DgDocumentType::setDocHolderFormattedName()
     * @uses DgDocumentType::setDocHolderName()
     * @uses DgDocumentType::setDocLimitations()
     * @uses DgDocumentType::setAdditionalPersonNames()
     * @uses DgDocumentType::setShareSynchInd()
     * @uses DgDocumentType::setShareMarketInd()
     * @uses DgDocumentType::setDocIssueAuthority()
     * @uses DgDocumentType::setDocIssueLocation()
     * @uses DgDocumentType::setDocID()
     * @uses DgDocumentType::setDocType()
     * @uses DgDocumentType::setInnerDocType()
     * @uses DgDocumentType::setGender()
     * @uses DgDocumentType::setBirthDate()
     * @uses DgDocumentType::setEffectiveDate()
     * @uses DgDocumentType::setExpireDate()
     * @uses DgDocumentType::setDocIssueStateProv()
     * @uses DgDocumentType::setDocIssueCountry()
     * @uses DgDocumentType::setAddressType()
     * @uses DgDocumentType::setAddressDetails()
     * @uses DgDocumentType::setCityCode()
     * @uses DgDocumentType::setState()
     * @uses DgDocumentType::setZipPostalCode()
     * @uses DgDocumentType::setBirthCountry()
     * @uses DgDocumentType::setDocHolderNationality()
     * @uses DgDocumentType::setContactName()
     * @uses DgDocumentType::setHolderType()
     * @param \dgsoft\StructType\DgPersonNameType $docHolderFormattedName
     * @param string $docHolderName
     * @param string[] $docLimitations
     * @param \dgsoft\ArrayType\DgArrayOfString1 $additionalPersonNames
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $docIssueAuthority
     * @param string $docIssueLocation
     * @param string $docID
     * @param string $docType
     * @param string $innerDocType
     * @param string $gender
     * @param string $birthDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $docIssueStateProv
     * @param string $docIssueCountry
     * @param string $addressType
     * @param string $addressDetails
     * @param string $cityCode
     * @param string $state
     * @param string $zipPostalCode
     * @param string $birthCountry
     * @param string $docHolderNationality
     * @param string $contactName
     * @param string $holderType
     */
    public function __construct(\dgsoft\StructType\DgPersonNameType $docHolderFormattedName = null, $docHolderName = null, array $docLimitations = array(), \dgsoft\ArrayType\DgArrayOfString1 $additionalPersonNames = null, $shareSynchInd = null, $shareMarketInd = null, $docIssueAuthority = null, $docIssueLocation = null, $docID = null, $docType = null, $innerDocType = null, $gender = null, $birthDate = null, $effectiveDate = null, $expireDate = null, $docIssueStateProv = null, $docIssueCountry = null, $addressType = null, $addressDetails = null, $cityCode = null, $state = null, $zipPostalCode = null, $birthCountry = null, $docHolderNationality = null, $contactName = null, $holderType = null)
    {
        $this
            ->setDocHolderFormattedName($docHolderFormattedName)
            ->setDocHolderName($docHolderName)
            ->setDocLimitations($docLimitations)
            ->setAdditionalPersonNames($additionalPersonNames)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDocIssueAuthority($docIssueAuthority)
            ->setDocIssueLocation($docIssueLocation)
            ->setDocID($docID)
            ->setDocType($docType)
            ->setInnerDocType($innerDocType)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setDocIssueStateProv($docIssueStateProv)
            ->setDocIssueCountry($docIssueCountry)
            ->setAddressType($addressType)
            ->setAddressDetails($addressDetails)
            ->setCityCode($cityCode)
            ->setState($state)
            ->setZipPostalCode($zipPostalCode)
            ->setBirthCountry($birthCountry)
            ->setDocHolderNationality($docHolderNationality)
            ->setContactName($contactName)
            ->setHolderType($holderType);
    }
    /**
     * Get DocHolderFormattedName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getDocHolderFormattedName()
    {
        return $this->DocHolderFormattedName;
    }
    /**
     * Set DocHolderFormattedName value
     * @param \dgsoft\StructType\DgPersonNameType $docHolderFormattedName
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocHolderFormattedName(\dgsoft\StructType\DgPersonNameType $docHolderFormattedName = null)
    {
        $this->DocHolderFormattedName = $docHolderFormattedName;
        return $this;
    }
    /**
     * Get DocHolderName value
     * @return string|null
     */
    public function getDocHolderName()
    {
        return $this->DocHolderName;
    }
    /**
     * Set DocHolderName value
     * @param string $docHolderName
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocHolderName($docHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderName) && !is_string($docHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docHolderName)), __LINE__);
        }
        $this->DocHolderName = $docHolderName;
        return $this;
    }
    /**
     * Get DocLimitations value
     * @return string[]|null
     */
    public function getDocLimitations()
    {
        return $this->DocLimitations;
    }
    /**
     * Set DocLimitations value
     * @throws \InvalidArgumentException
     * @param string[] $docLimitations
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocLimitations(array $docLimitations = array())
    {
        foreach ($docLimitations as $documentTypeDocLimitationsItem) {
            // validation for constraint: itemType
            if (!is_string($documentTypeDocLimitationsItem)) {
                throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of string, "%s" given', is_object($documentTypeDocLimitationsItem) ? get_class($documentTypeDocLimitationsItem) : gettype($documentTypeDocLimitationsItem)), __LINE__);
            }
        }
        $this->DocLimitations = $docLimitations;
        return $this;
    }
    /**
     * Add item to DocLimitations value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function addToDocLimitations($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocLimitations[] = $item;
        return $this;
    }
    /**
     * Get AdditionalPersonNames value
     * @return \dgsoft\ArrayType\DgArrayOfString1|null
     */
    public function getAdditionalPersonNames()
    {
        return $this->AdditionalPersonNames;
    }
    /**
     * Set AdditionalPersonNames value
     * @param \dgsoft\ArrayType\DgArrayOfString1 $additionalPersonNames
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setAdditionalPersonNames(\dgsoft\ArrayType\DgArrayOfString1 $additionalPersonNames = null)
    {
        $this->AdditionalPersonNames = $additionalPersonNames;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DocIssueAuthority value
     * @return string|null
     */
    public function getDocIssueAuthority()
    {
        return $this->DocIssueAuthority;
    }
    /**
     * Set DocIssueAuthority value
     * @param string $docIssueAuthority
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocIssueAuthority($docIssueAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueAuthority) && !is_string($docIssueAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueAuthority)), __LINE__);
        }
        $this->DocIssueAuthority = $docIssueAuthority;
        return $this;
    }
    /**
     * Get DocIssueLocation value
     * @return string|null
     */
    public function getDocIssueLocation()
    {
        return $this->DocIssueLocation;
    }
    /**
     * Set DocIssueLocation value
     * @param string $docIssueLocation
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocIssueLocation($docIssueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueLocation) && !is_string($docIssueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueLocation)), __LINE__);
        }
        $this->DocIssueLocation = $docIssueLocation;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get InnerDocType value
     * @return string|null
     */
    public function getInnerDocType()
    {
        return $this->InnerDocType;
    }
    /**
     * Set InnerDocType value
     * @param string $innerDocType
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setInnerDocType($innerDocType = null)
    {
        // validation for constraint: string
        if (!is_null($innerDocType) && !is_string($innerDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($innerDocType)), __LINE__);
        }
        $this->InnerDocType = $innerDocType;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get DocIssueStateProv value
     * @return string|null
     */
    public function getDocIssueStateProv()
    {
        return $this->DocIssueStateProv;
    }
    /**
     * Set DocIssueStateProv value
     * @param string $docIssueStateProv
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocIssueStateProv($docIssueStateProv = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueStateProv) && !is_string($docIssueStateProv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueStateProv)), __LINE__);
        }
        $this->DocIssueStateProv = $docIssueStateProv;
        return $this;
    }
    /**
     * Get DocIssueCountry value
     * @return string|null
     */
    public function getDocIssueCountry()
    {
        return $this->DocIssueCountry;
    }
    /**
     * Set DocIssueCountry value
     * @param string $docIssueCountry
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocIssueCountry($docIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueCountry) && !is_string($docIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueCountry)), __LINE__);
        }
        $this->DocIssueCountry = $docIssueCountry;
        return $this;
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get AddressDetails value
     * @return string|null
     */
    public function getAddressDetails()
    {
        return $this->AddressDetails;
    }
    /**
     * Set AddressDetails value
     * @param string $addressDetails
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setAddressDetails($addressDetails = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetails) && !is_string($addressDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressDetails)), __LINE__);
        }
        $this->AddressDetails = $addressDetails;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipPostalCode value
     * @return string|null
     */
    public function getZipPostalCode()
    {
        return $this->ZipPostalCode;
    }
    /**
     * Set ZipPostalCode value
     * @param string $zipPostalCode
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setZipPostalCode($zipPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipPostalCode) && !is_string($zipPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipPostalCode)), __LINE__);
        }
        $this->ZipPostalCode = $zipPostalCode;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get DocHolderNationality value
     * @return string|null
     */
    public function getDocHolderNationality()
    {
        return $this->DocHolderNationality;
    }
    /**
     * Set DocHolderNationality value
     * @param string $docHolderNationality
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setDocHolderNationality($docHolderNationality = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderNationality) && !is_string($docHolderNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docHolderNationality)), __LINE__);
        }
        $this->DocHolderNationality = $docHolderNationality;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get HolderType value
     * @return string|null
     */
    public function getHolderType()
    {
        return $this->HolderType;
    }
    /**
     * Set HolderType value
     * @param string $holderType
     * @return \dgsoft\StructType\DgDocumentType
     */
    public function setHolderType($holderType = null)
    {
        // validation for constraint: string
        if (!is_null($holderType) && !is_string($holderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderType)), __LINE__);
        }
        $this->HolderType = $holderType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
