<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDiscountType extends DgTotalType
{
    /**
     * The DiscountReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $DiscountReason;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The DiscountCode
     * @var string
     */
    public $DiscountCode;
    /**
     * The RestrictedDisplayIndicator
     * @var bool
     */
    public $RestrictedDisplayIndicator;
    /**
     * Constructor method for DiscountType
     * @uses DgDiscountType::setDiscountReason()
     * @uses DgDiscountType::setTaxInclusive()
     * @uses DgDiscountType::setPercent()
     * @uses DgDiscountType::setDiscountCode()
     * @uses DgDiscountType::setRestrictedDisplayIndicator()
     * @param \dgsoft\StructType\DgParagraphType $discountReason
     * @param bool $taxInclusive
     * @param float $percent
     * @param string $discountCode
     * @param bool $restrictedDisplayIndicator
     */
    public function __construct(\dgsoft\StructType\DgParagraphType $discountReason = null, $taxInclusive = null, $percent = null, $discountCode = null, $restrictedDisplayIndicator = null)
    {
        $this
            ->setDiscountReason($discountReason)
            ->setTaxInclusive($taxInclusive)
            ->setPercent($percent)
            ->setDiscountCode($discountCode)
            ->setRestrictedDisplayIndicator($restrictedDisplayIndicator);
    }
    /**
     * Get DiscountReason value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getDiscountReason()
    {
        return $this->DiscountReason;
    }
    /**
     * Set DiscountReason value
     * @param \dgsoft\StructType\DgParagraphType $discountReason
     * @return \dgsoft\StructType\DgDiscountType
     */
    public function setDiscountReason(\dgsoft\StructType\DgParagraphType $discountReason = null)
    {
        $this->DiscountReason = $discountReason;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \dgsoft\StructType\DgDiscountType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgDiscountType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \dgsoft\StructType\DgDiscountType
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get RestrictedDisplayIndicator value
     * @return bool|null
     */
    public function getRestrictedDisplayIndicator()
    {
        return $this->RestrictedDisplayIndicator;
    }
    /**
     * Set RestrictedDisplayIndicator value
     * @param bool $restrictedDisplayIndicator
     * @return \dgsoft\StructType\DgDiscountType
     */
    public function setRestrictedDisplayIndicator($restrictedDisplayIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedDisplayIndicator) && !is_bool($restrictedDisplayIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($restrictedDisplayIndicator)), __LINE__);
        }
        $this->RestrictedDisplayIndicator = $restrictedDisplayIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDiscountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
