<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCustomerType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddress[]
     */
    public $Address;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgURL_Type[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The RelatedTraveler
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRelatedTravelerType[]
     */
    public $RelatedTraveler;
    /**
     * The ContactPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDocumentType[]
     */
    public $Document;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $EmployerInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Deceased
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * @var string
     */
    public $LockoutType;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The VIP_Indicator
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for CustomerType
     * @uses DgCustomerType::setPersonName()
     * @uses DgCustomerType::setTelephone()
     * @uses DgCustomerType::setEmail()
     * @uses DgCustomerType::setAddress()
     * @uses DgCustomerType::setURL()
     * @uses DgCustomerType::setCitizenCountryName()
     * @uses DgCustomerType::setPhysChallName()
     * @uses DgCustomerType::setPetInfo()
     * @uses DgCustomerType::setPaymentForm()
     * @uses DgCustomerType::setRelatedTraveler()
     * @uses DgCustomerType::setContactPerson()
     * @uses DgCustomerType::setDocument()
     * @uses DgCustomerType::setCustLoyalty()
     * @uses DgCustomerType::setEmployeeInfo()
     * @uses DgCustomerType::setEmployerInfo()
     * @uses DgCustomerType::setTPA_Extensions()
     * @uses DgCustomerType::setGender()
     * @uses DgCustomerType::setDeceased()
     * @uses DgCustomerType::setLockoutType()
     * @uses DgCustomerType::setBirthDate()
     * @uses DgCustomerType::setCurrencyCode()
     * @uses DgCustomerType::setDecimalPlaces()
     * @uses DgCustomerType::setVIP_Indicator()
     * @uses DgCustomerType::setText()
     * @uses DgCustomerType::setLanguage()
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @param \dgsoft\StructType\DgAddress[] $address
     * @param \dgsoft\StructType\DgURL_Type[] $uRL
     * @param \dgsoft\StructType\DgCitizenCountryName[] $citizenCountryName
     * @param string[] $physChallName
     * @param string[] $petInfo
     * @param \dgsoft\StructType\DgPaymentFormType[] $paymentForm
     * @param \dgsoft\StructType\DgRelatedTravelerType[] $relatedTraveler
     * @param \dgsoft\StructType\DgContactPersonType[] $contactPerson
     * @param \dgsoft\StructType\DgDocumentType[] $document
     * @param \dgsoft\StructType\DgCustLoyalty[] $custLoyalty
     * @param \dgsoft\StructType\DgEmployeeInfoType[] $employeeInfo
     * @param \dgsoft\StructType\DgCompanyNameType $employerInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $gender
     * @param bool $deceased
     * @param string $lockoutType
     * @param string $birthDate
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $vIP_Indicator
     * @param string $text
     * @param string $language
     */
    public function __construct(\dgsoft\StructType\DgPersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $relatedTraveler = array(), array $contactPerson = array(), array $document = array(), array $custLoyalty = array(), array $employeeInfo = array(), \dgsoft\StructType\DgCompanyNameType $employerInfo = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $gender = null, $deceased = null, $lockoutType = null, $birthDate = null, $currencyCode = null, $decimalPlaces = null, $vIP_Indicator = null, $text = null, $language = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setRelatedTraveler($relatedTraveler)
            ->setContactPerson($contactPerson)
            ->setDocument($document)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setGender($gender)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setVIP_Indicator($vIP_Indicator)
            ->setText($text)
            ->setLanguage($language);
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \dgsoft\StructType\DgTelephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : gettype($customerTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToTelephone(\dgsoft\StructType\DgTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \dgsoft\StructType\DgEmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \dgsoft\StructType\DgEmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : gettype($customerTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToEmail(\dgsoft\StructType\DgEmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddress[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddress[] $address
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \dgsoft\StructType\DgAddress) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddress, "%s" given', is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : gettype($customerTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddress $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToAddress(\dgsoft\StructType\DgAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddress) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \dgsoft\StructType\DgURL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgURL_Type[] $uRL
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setURL(array $uRL = array())
    {
        foreach ($uRL as $customerTypeURLItem) {
            // validation for constraint: itemType
            if (!$customerTypeURLItem instanceof \dgsoft\StructType\DgURL_Type) {
                throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \dgsoft\StructType\DgURL_Type, "%s" given', is_object($customerTypeURLItem) ? get_class($customerTypeURLItem) : gettype($customerTypeURLItem)), __LINE__);
            }
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgURL_Type $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToURL(\dgsoft\StructType\DgURL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgURL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \dgsoft\StructType\DgURL_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \dgsoft\StructType\DgCitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCitizenCountryName[] $citizenCountryName
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        foreach ($citizenCountryName as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \dgsoft\StructType\DgCitizenCountryName) {
                throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of \dgsoft\StructType\DgCitizenCountryName, "%s" given', is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : gettype($customerTypeCitizenCountryNameItem)), __LINE__);
            }
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCitizenCountryName $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToCitizenCountryName(\dgsoft\StructType\DgCitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of \dgsoft\StructType\DgCitizenCountryName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return string[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param string[] $physChallName
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        foreach ($physChallName as $customerTypePhysChallNameItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePhysChallNameItem)) {
                throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of string, "%s" given', is_object($customerTypePhysChallNameItem) ? get_class($customerTypePhysChallNameItem) : gettype($customerTypePhysChallNameItem)), __LINE__);
            }
        }
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToPhysChallName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return string[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param string[] $petInfo
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        foreach ($petInfo as $customerTypePetInfoItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePetInfoItem)) {
                throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of string, "%s" given', is_object($customerTypePetInfoItem) ? get_class($customerTypePetInfoItem) : gettype($customerTypePetInfoItem)), __LINE__);
            }
        }
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToPetInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \dgsoft\StructType\DgPaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormType[] $paymentForm
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        foreach ($paymentForm as $customerTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerTypePaymentFormItem instanceof \dgsoft\StructType\DgPaymentFormType) {
                throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \dgsoft\StructType\DgPaymentFormType, "%s" given', is_object($customerTypePaymentFormItem) ? get_class($customerTypePaymentFormItem) : gettype($customerTypePaymentFormItem)), __LINE__);
            }
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormType $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToPaymentForm(\dgsoft\StructType\DgPaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \dgsoft\StructType\DgPaymentFormType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get RelatedTraveler value
     * @return \dgsoft\StructType\DgRelatedTravelerType[]|null
     */
    public function getRelatedTraveler()
    {
        return $this->RelatedTraveler;
    }
    /**
     * Set RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRelatedTravelerType[] $relatedTraveler
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setRelatedTraveler(array $relatedTraveler = array())
    {
        foreach ($relatedTraveler as $customerTypeRelatedTravelerItem) {
            // validation for constraint: itemType
            if (!$customerTypeRelatedTravelerItem instanceof \dgsoft\StructType\DgRelatedTravelerType) {
                throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of \dgsoft\StructType\DgRelatedTravelerType, "%s" given', is_object($customerTypeRelatedTravelerItem) ? get_class($customerTypeRelatedTravelerItem) : gettype($customerTypeRelatedTravelerItem)), __LINE__);
            }
        }
        $this->RelatedTraveler = $relatedTraveler;
        return $this;
    }
    /**
     * Add item to RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRelatedTravelerType $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToRelatedTraveler(\dgsoft\StructType\DgRelatedTravelerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRelatedTravelerType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of \dgsoft\StructType\DgRelatedTravelerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedTraveler[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \dgsoft\StructType\DgContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactPersonType[] $contactPerson
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        foreach ($contactPerson as $customerTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$customerTypeContactPersonItem instanceof \dgsoft\StructType\DgContactPersonType) {
                throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \dgsoft\StructType\DgContactPersonType, "%s" given', is_object($customerTypeContactPersonItem) ? get_class($customerTypeContactPersonItem) : gettype($customerTypeContactPersonItem)), __LINE__);
            }
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactPersonType $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToContactPerson(\dgsoft\StructType\DgContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \dgsoft\StructType\DgContactPersonType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \dgsoft\StructType\DgDocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocumentType[] $document
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$customerTypeDocumentItem instanceof \dgsoft\StructType\DgDocumentType) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocumentType, "%s" given', is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : gettype($customerTypeDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocumentType $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToDocument(\dgsoft\StructType\DgDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \dgsoft\StructType\DgCustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustLoyalty[] $custLoyalty
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        foreach ($custLoyalty as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \dgsoft\StructType\DgCustLoyalty) {
                throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgCustLoyalty, "%s" given', is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : gettype($customerTypeCustLoyaltyItem)), __LINE__);
            }
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustLoyalty $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToCustLoyalty(\dgsoft\StructType\DgCustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgCustLoyalty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \dgsoft\StructType\DgEmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployeeInfoType[] $employeeInfo
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $customerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmployeeInfoItem instanceof \dgsoft\StructType\DgEmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \dgsoft\StructType\DgEmployeeInfoType, "%s" given', is_object($customerTypeEmployeeInfoItem) ? get_class($customerTypeEmployeeInfoItem) : gettype($customerTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployeeInfoType $item
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function addToEmployeeInfo(\dgsoft\StructType\DgEmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \dgsoft\StructType\DgEmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param \dgsoft\StructType\DgCompanyNameType $employerInfo
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setEmployerInfo(\dgsoft\StructType\DgCompanyNameType $employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutType) && !is_string($lockoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lockoutType)), __LINE__);
        }
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP_Indicator) && !is_bool($vIP_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vIP_Indicator)), __LINE__);
        }
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \dgsoft\StructType\DgCustomerType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
