<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredTravelerType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCoveredTravelerType extends AbstractStructBase
{
    /**
     * The CoveredPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoveredTravelerTypeCoveredPerson
     */
    public $CoveredPerson;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType[]
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephone[]
     */
    public $Telephone;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoveredTravelerTypeCitizenCountryName
     */
    public $CitizenCountryName;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDocumentType[]
     */
    public $Document;
    /**
     * The EmergencyContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgContactPersonType[]
     */
    public $EmergencyContact;
    /**
     * The Beneficiary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary[]
     */
    public $Beneficiary;
    /**
     * The IndCoverageReqs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgIndCoverageReqsType
     */
    public $IndCoverageReqs;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for CoveredTravelerType
     * @uses DgCoveredTravelerType::setCoveredPerson()
     * @uses DgCoveredTravelerType::setEmail()
     * @uses DgCoveredTravelerType::setAddress()
     * @uses DgCoveredTravelerType::setTelephone()
     * @uses DgCoveredTravelerType::setCitizenCountryName()
     * @uses DgCoveredTravelerType::setDocument()
     * @uses DgCoveredTravelerType::setEmergencyContact()
     * @uses DgCoveredTravelerType::setBeneficiary()
     * @uses DgCoveredTravelerType::setIndCoverageReqs()
     * @uses DgCoveredTravelerType::setRPH()
     * @param \dgsoft\StructType\DgCoveredTravelerTypeCoveredPerson $coveredPerson
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @param \dgsoft\StructType\DgAddressInfoType[] $address
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @param \dgsoft\StructType\DgCoveredTravelerTypeCitizenCountryName $citizenCountryName
     * @param \dgsoft\StructType\DgDocumentType[] $document
     * @param \dgsoft\StructType\DgContactPersonType[] $emergencyContact
     * @param \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary[] $beneficiary
     * @param \dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs
     * @param string $rPH
     */
    public function __construct(\dgsoft\StructType\DgCoveredTravelerTypeCoveredPerson $coveredPerson = null, array $email = array(), array $address = array(), array $telephone = array(), \dgsoft\StructType\DgCoveredTravelerTypeCitizenCountryName $citizenCountryName = null, array $document = array(), array $emergencyContact = array(), array $beneficiary = array(), \dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs = null, $rPH = null)
    {
        $this
            ->setCoveredPerson($coveredPerson)
            ->setEmail($email)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setCitizenCountryName($citizenCountryName)
            ->setDocument($document)
            ->setEmergencyContact($emergencyContact)
            ->setBeneficiary($beneficiary)
            ->setIndCoverageReqs($indCoverageReqs)
            ->setRPH($rPH);
    }
    /**
     * Get CoveredPerson value
     * @return \dgsoft\StructType\DgCoveredTravelerTypeCoveredPerson|null
     */
    public function getCoveredPerson()
    {
        return $this->CoveredPerson;
    }
    /**
     * Set CoveredPerson value
     * @param \dgsoft\StructType\DgCoveredTravelerTypeCoveredPerson $coveredPerson
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setCoveredPerson(\dgsoft\StructType\DgCoveredTravelerTypeCoveredPerson $coveredPerson = null)
    {
        $this->CoveredPerson = $coveredPerson;
        return $this;
    }
    /**
     * Get Email value
     * @return \dgsoft\StructType\DgEmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $coveredTravelerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeEmailItem instanceof \dgsoft\StructType\DgEmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($coveredTravelerTypeEmailItem) ? get_class($coveredTravelerTypeEmailItem) : gettype($coveredTravelerTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType $item
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function addToEmail(\dgsoft\StructType\DgEmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddressInfoType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType[] $address
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $coveredTravelerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeAddressItem instanceof \dgsoft\StructType\DgAddressInfoType) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($coveredTravelerTypeAddressItem) ? get_class($coveredTravelerTypeAddressItem) : gettype($coveredTravelerTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType $item
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function addToAddress(\dgsoft\StructType\DgAddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $coveredTravelerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeTelephoneItem instanceof \dgsoft\StructType\DgTelephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($coveredTravelerTypeTelephoneItem) ? get_class($coveredTravelerTypeTelephoneItem) : gettype($coveredTravelerTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone $item
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function addToTelephone(\dgsoft\StructType\DgTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \dgsoft\StructType\DgCoveredTravelerTypeCitizenCountryName|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @param \dgsoft\StructType\DgCoveredTravelerTypeCitizenCountryName $citizenCountryName
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setCitizenCountryName(\dgsoft\StructType\DgCoveredTravelerTypeCitizenCountryName $citizenCountryName = null)
    {
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Get Document value
     * @return \dgsoft\StructType\DgDocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocumentType[] $document
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $coveredTravelerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeDocumentItem instanceof \dgsoft\StructType\DgDocumentType) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocumentType, "%s" given', is_object($coveredTravelerTypeDocumentItem) ? get_class($coveredTravelerTypeDocumentItem) : gettype($coveredTravelerTypeDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocumentType $item
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function addToDocument(\dgsoft\StructType\DgDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get EmergencyContact value
     * @return \dgsoft\StructType\DgContactPersonType[]|null
     */
    public function getEmergencyContact()
    {
        return $this->EmergencyContact;
    }
    /**
     * Set EmergencyContact value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactPersonType[] $emergencyContact
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setEmergencyContact(array $emergencyContact = array())
    {
        foreach ($emergencyContact as $coveredTravelerTypeEmergencyContactItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeEmergencyContactItem instanceof \dgsoft\StructType\DgContactPersonType) {
                throw new \InvalidArgumentException(sprintf('The EmergencyContact property can only contain items of \dgsoft\StructType\DgContactPersonType, "%s" given', is_object($coveredTravelerTypeEmergencyContactItem) ? get_class($coveredTravelerTypeEmergencyContactItem) : gettype($coveredTravelerTypeEmergencyContactItem)), __LINE__);
            }
        }
        $this->EmergencyContact = $emergencyContact;
        return $this;
    }
    /**
     * Add item to EmergencyContact value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactPersonType $item
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function addToEmergencyContact(\dgsoft\StructType\DgContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The EmergencyContact property can only contain items of \dgsoft\StructType\DgContactPersonType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmergencyContact[] = $item;
        return $this;
    }
    /**
     * Get Beneficiary value
     * @return \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary[]|null
     */
    public function getBeneficiary()
    {
        return $this->Beneficiary;
    }
    /**
     * Set Beneficiary value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary[] $beneficiary
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setBeneficiary(array $beneficiary = array())
    {
        foreach ($beneficiary as $coveredTravelerTypeBeneficiaryItem) {
            // validation for constraint: itemType
            if (!$coveredTravelerTypeBeneficiaryItem instanceof \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary) {
                throw new \InvalidArgumentException(sprintf('The Beneficiary property can only contain items of \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary, "%s" given', is_object($coveredTravelerTypeBeneficiaryItem) ? get_class($coveredTravelerTypeBeneficiaryItem) : gettype($coveredTravelerTypeBeneficiaryItem)), __LINE__);
            }
        }
        $this->Beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Add item to Beneficiary value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary $item
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function addToBeneficiary(\dgsoft\StructType\DgCoveredTravelerTypeBeneficiary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary) {
            throw new \InvalidArgumentException(sprintf('The Beneficiary property can only contain items of \dgsoft\StructType\DgCoveredTravelerTypeBeneficiary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Beneficiary[] = $item;
        return $this;
    }
    /**
     * Get IndCoverageReqs value
     * @return \dgsoft\StructType\DgIndCoverageReqsType|null
     */
    public function getIndCoverageReqs()
    {
        return $this->IndCoverageReqs;
    }
    /**
     * Set IndCoverageReqs value
     * @param \dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setIndCoverageReqs(\dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs = null)
    {
        $this->IndCoverageReqs = $indCoverageReqs;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCoveredTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
