<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCoverageType extends AbstractStructBase
{
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoverageDetailsType[]
     */
    public $Details;
    /**
     * The CoverageType
     * @var string
     */
    public $CoverageType;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for CoverageType
     * @uses DgCoverageType::setDetails()
     * @uses DgCoverageType::setCoverageType()
     * @uses DgCoverageType::setCode()
     * @param \dgsoft\StructType\DgCoverageDetailsType[] $details
     * @param string $coverageType
     * @param string $code
     */
    public function __construct(array $details = array(), $coverageType = null, $code = null)
    {
        $this
            ->setDetails($details)
            ->setCoverageType($coverageType)
            ->setCode($code);
    }
    /**
     * Get Details value
     * @return \dgsoft\StructType\DgCoverageDetailsType[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCoverageDetailsType[] $details
     * @return \dgsoft\StructType\DgCoverageType
     */
    public function setDetails(array $details = array())
    {
        foreach ($details as $coverageTypeDetailsItem) {
            // validation for constraint: itemType
            if (!$coverageTypeDetailsItem instanceof \dgsoft\StructType\DgCoverageDetailsType) {
                throw new \InvalidArgumentException(sprintf('The Details property can only contain items of \dgsoft\StructType\DgCoverageDetailsType, "%s" given', is_object($coverageTypeDetailsItem) ? get_class($coverageTypeDetailsItem) : gettype($coverageTypeDetailsItem)), __LINE__);
            }
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCoverageDetailsType $item
     * @return \dgsoft\StructType\DgCoverageType
     */
    public function addToDetails(\dgsoft\StructType\DgCoverageDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCoverageDetailsType) {
            throw new \InvalidArgumentException(sprintf('The Details property can only contain items of \dgsoft\StructType\DgCoverageDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Get CoverageType value
     * @return string|null
     */
    public function getCoverageType()
    {
        return $this->CoverageType;
    }
    /**
     * Set CoverageType value
     * @param string $coverageType
     * @return \dgsoft\StructType\DgCoverageType
     */
    public function setCoverageType($coverageType = null)
    {
        // validation for constraint: string
        if (!is_null($coverageType) && !is_string($coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coverageType)), __LINE__);
        }
        $this->CoverageType = $coverageType;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgCoverageType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCoverageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
