<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveragePricedType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCoveragePricedType extends AbstractStructBase
{
    /**
     * The Coverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoverageType
     */
    public $Coverage;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleChargeType
     */
    public $Charge;
    /**
     * The Required
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Required;
    /**
     * Constructor method for CoveragePricedType
     * @uses DgCoveragePricedType::setCoverage()
     * @uses DgCoveragePricedType::setCharge()
     * @uses DgCoveragePricedType::setRequired()
     * @param \dgsoft\StructType\DgCoverageType $coverage
     * @param \dgsoft\StructType\DgVehicleChargeType $charge
     * @param bool $required
     */
    public function __construct(\dgsoft\StructType\DgCoverageType $coverage = null, \dgsoft\StructType\DgVehicleChargeType $charge = null, $required = false)
    {
        $this
            ->setCoverage($coverage)
            ->setCharge($charge)
            ->setRequired($required);
    }
    /**
     * Get Coverage value
     * @return \dgsoft\StructType\DgCoverageType|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * Set Coverage value
     * @param \dgsoft\StructType\DgCoverageType $coverage
     * @return \dgsoft\StructType\DgCoveragePricedType
     */
    public function setCoverage(\dgsoft\StructType\DgCoverageType $coverage = null)
    {
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Get Charge value
     * @return \dgsoft\StructType\DgVehicleChargeType|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \dgsoft\StructType\DgVehicleChargeType $charge
     * @return \dgsoft\StructType\DgCoveragePricedType
     */
    public function setCharge(\dgsoft\StructType\DgVehicleChargeType $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \dgsoft\StructType\DgCoveragePricedType
     */
    public function setRequired($required = false)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCoveragePricedType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
