<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateSetting StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCorporateSetting extends AbstractStructBase
{
    /**
     * The RailProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RailProviderType;
    /**
     * The HotelProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HotelProviderType;
    /**
     * The CarProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CarProviderType;
    /**
     * The DisplayRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DisplayRule;
    /**
     * The TripApprovalRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TripApprovalRule;
    /**
     * The RequireJustificationRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RequireJustificationRule;
    /**
     * The RequireJustificationOnlyFlightRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RequireJustificationOnlyFlightRule;
    /**
     * The RequireJusificationForDeclineProcess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RequireJusificationForDeclineProcess;
    /**
     * The AllowBookingOnlyArrangerOrSelectedMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AllowBookingOnlyArrangerOrSelectedMembers;
    /**
     * The AllowETicketForNext
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AllowETicketForNext;
    /**
     * The FlightProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightProviderType;
    /**
     * The ApplyApprovalRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplyApprovalRules;
    /**
     * Constructor method for CorporateSetting
     * @uses DgCorporateSetting::setRailProviderType()
     * @uses DgCorporateSetting::setHotelProviderType()
     * @uses DgCorporateSetting::setCarProviderType()
     * @uses DgCorporateSetting::setDisplayRule()
     * @uses DgCorporateSetting::setTripApprovalRule()
     * @uses DgCorporateSetting::setRequireJustificationRule()
     * @uses DgCorporateSetting::setRequireJustificationOnlyFlightRule()
     * @uses DgCorporateSetting::setRequireJusificationForDeclineProcess()
     * @uses DgCorporateSetting::setAllowBookingOnlyArrangerOrSelectedMembers()
     * @uses DgCorporateSetting::setAllowETicketForNext()
     * @uses DgCorporateSetting::setFlightProviderType()
     * @uses DgCorporateSetting::setApplyApprovalRules()
     * @param string $railProviderType
     * @param string $hotelProviderType
     * @param string $carProviderType
     * @param string $displayRule
     * @param string $tripApprovalRule
     * @param bool $requireJustificationRule
     * @param bool $requireJustificationOnlyFlightRule
     * @param bool $requireJusificationForDeclineProcess
     * @param bool $allowBookingOnlyArrangerOrSelectedMembers
     * @param int $allowETicketForNext
     * @param string $flightProviderType
     * @param string $applyApprovalRules
     */
    public function __construct($railProviderType = null, $hotelProviderType = null, $carProviderType = null, $displayRule = null, $tripApprovalRule = null, $requireJustificationRule = null, $requireJustificationOnlyFlightRule = null, $requireJusificationForDeclineProcess = null, $allowBookingOnlyArrangerOrSelectedMembers = null, $allowETicketForNext = null, $flightProviderType = null, $applyApprovalRules = null)
    {
        $this
            ->setRailProviderType($railProviderType)
            ->setHotelProviderType($hotelProviderType)
            ->setCarProviderType($carProviderType)
            ->setDisplayRule($displayRule)
            ->setTripApprovalRule($tripApprovalRule)
            ->setRequireJustificationRule($requireJustificationRule)
            ->setRequireJustificationOnlyFlightRule($requireJustificationOnlyFlightRule)
            ->setRequireJusificationForDeclineProcess($requireJusificationForDeclineProcess)
            ->setAllowBookingOnlyArrangerOrSelectedMembers($allowBookingOnlyArrangerOrSelectedMembers)
            ->setAllowETicketForNext($allowETicketForNext)
            ->setFlightProviderType($flightProviderType)
            ->setApplyApprovalRules($applyApprovalRules);
    }
    /**
     * Get RailProviderType value
     * @return string
     */
    public function getRailProviderType()
    {
        return $this->RailProviderType;
    }
    /**
     * Set RailProviderType value
     * @uses \dgsoft\EnumType\DgRailProviderTypeEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgRailProviderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $railProviderType
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setRailProviderType($railProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRailProviderTypeEnum::valueIsValid($railProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $railProviderType, implode(', ', \dgsoft\EnumType\DgRailProviderTypeEnum::getValidValues())), __LINE__);
        }
        $this->RailProviderType = $railProviderType;
        return $this;
    }
    /**
     * Get HotelProviderType value
     * @return string
     */
    public function getHotelProviderType()
    {
        return $this->HotelProviderType;
    }
    /**
     * Set HotelProviderType value
     * @uses \dgsoft\EnumType\DgHotelProviderTypeEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgHotelProviderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hotelProviderType
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setHotelProviderType($hotelProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgHotelProviderTypeEnum::valueIsValid($hotelProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hotelProviderType, implode(', ', \dgsoft\EnumType\DgHotelProviderTypeEnum::getValidValues())), __LINE__);
        }
        $this->HotelProviderType = $hotelProviderType;
        return $this;
    }
    /**
     * Get CarProviderType value
     * @return string
     */
    public function getCarProviderType()
    {
        return $this->CarProviderType;
    }
    /**
     * Set CarProviderType value
     * @uses \dgsoft\EnumType\DgCarProviderTypeEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgCarProviderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carProviderType
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setCarProviderType($carProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCarProviderTypeEnum::valueIsValid($carProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $carProviderType, implode(', ', \dgsoft\EnumType\DgCarProviderTypeEnum::getValidValues())), __LINE__);
        }
        $this->CarProviderType = $carProviderType;
        return $this;
    }
    /**
     * Get DisplayRule value
     * @return string
     */
    public function getDisplayRule()
    {
        return $this->DisplayRule;
    }
    /**
     * Set DisplayRule value
     * @uses \dgsoft\EnumType\DgDisplayRuleEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgDisplayRuleEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayRule
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setDisplayRule($displayRule = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDisplayRuleEnum::valueIsValid($displayRule)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $displayRule, implode(', ', \dgsoft\EnumType\DgDisplayRuleEnum::getValidValues())), __LINE__);
        }
        $this->DisplayRule = $displayRule;
        return $this;
    }
    /**
     * Get TripApprovalRule value
     * @return string
     */
    public function getTripApprovalRule()
    {
        return $this->TripApprovalRule;
    }
    /**
     * Set TripApprovalRule value
     * @uses \dgsoft\EnumType\DgTripApprovalRuleEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgTripApprovalRuleEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripApprovalRule
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setTripApprovalRule($tripApprovalRule = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTripApprovalRuleEnum::valueIsValid($tripApprovalRule)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tripApprovalRule, implode(', ', \dgsoft\EnumType\DgTripApprovalRuleEnum::getValidValues())), __LINE__);
        }
        $this->TripApprovalRule = $tripApprovalRule;
        return $this;
    }
    /**
     * Get RequireJustificationRule value
     * @return bool
     */
    public function getRequireJustificationRule()
    {
        return $this->RequireJustificationRule;
    }
    /**
     * Set RequireJustificationRule value
     * @param bool $requireJustificationRule
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setRequireJustificationRule($requireJustificationRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($requireJustificationRule) && !is_bool($requireJustificationRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requireJustificationRule)), __LINE__);
        }
        $this->RequireJustificationRule = $requireJustificationRule;
        return $this;
    }
    /**
     * Get RequireJustificationOnlyFlightRule value
     * @return bool
     */
    public function getRequireJustificationOnlyFlightRule()
    {
        return $this->RequireJustificationOnlyFlightRule;
    }
    /**
     * Set RequireJustificationOnlyFlightRule value
     * @param bool $requireJustificationOnlyFlightRule
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setRequireJustificationOnlyFlightRule($requireJustificationOnlyFlightRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($requireJustificationOnlyFlightRule) && !is_bool($requireJustificationOnlyFlightRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requireJustificationOnlyFlightRule)), __LINE__);
        }
        $this->RequireJustificationOnlyFlightRule = $requireJustificationOnlyFlightRule;
        return $this;
    }
    /**
     * Get RequireJusificationForDeclineProcess value
     * @return bool
     */
    public function getRequireJusificationForDeclineProcess()
    {
        return $this->RequireJusificationForDeclineProcess;
    }
    /**
     * Set RequireJusificationForDeclineProcess value
     * @param bool $requireJusificationForDeclineProcess
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setRequireJusificationForDeclineProcess($requireJusificationForDeclineProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($requireJusificationForDeclineProcess) && !is_bool($requireJusificationForDeclineProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requireJusificationForDeclineProcess)), __LINE__);
        }
        $this->RequireJusificationForDeclineProcess = $requireJusificationForDeclineProcess;
        return $this;
    }
    /**
     * Get AllowBookingOnlyArrangerOrSelectedMembers value
     * @return bool
     */
    public function getAllowBookingOnlyArrangerOrSelectedMembers()
    {
        return $this->AllowBookingOnlyArrangerOrSelectedMembers;
    }
    /**
     * Set AllowBookingOnlyArrangerOrSelectedMembers value
     * @param bool $allowBookingOnlyArrangerOrSelectedMembers
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setAllowBookingOnlyArrangerOrSelectedMembers($allowBookingOnlyArrangerOrSelectedMembers = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowBookingOnlyArrangerOrSelectedMembers) && !is_bool($allowBookingOnlyArrangerOrSelectedMembers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowBookingOnlyArrangerOrSelectedMembers)), __LINE__);
        }
        $this->AllowBookingOnlyArrangerOrSelectedMembers = $allowBookingOnlyArrangerOrSelectedMembers;
        return $this;
    }
    /**
     * Get AllowETicketForNext value
     * @return int
     */
    public function getAllowETicketForNext()
    {
        return $this->AllowETicketForNext;
    }
    /**
     * Set AllowETicketForNext value
     * @param int $allowETicketForNext
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setAllowETicketForNext($allowETicketForNext = null)
    {
        // validation for constraint: int
        if (!is_null($allowETicketForNext) && !is_numeric($allowETicketForNext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allowETicketForNext)), __LINE__);
        }
        $this->AllowETicketForNext = $allowETicketForNext;
        return $this;
    }
    /**
     * Get FlightProviderType value
     * @return string|null
     */
    public function getFlightProviderType()
    {
        return $this->FlightProviderType;
    }
    /**
     * Set FlightProviderType value
     * @param string $flightProviderType
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setFlightProviderType($flightProviderType = null)
    {
        // validation for constraint: string
        if (!is_null($flightProviderType) && !is_string($flightProviderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightProviderType)), __LINE__);
        }
        $this->FlightProviderType = $flightProviderType;
        return $this;
    }
    /**
     * Get ApplyApprovalRules value
     * @return string|null
     */
    public function getApplyApprovalRules()
    {
        return $this->ApplyApprovalRules;
    }
    /**
     * Set ApplyApprovalRules value
     * @param string $applyApprovalRules
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public function setApplyApprovalRules($applyApprovalRules = null)
    {
        // validation for constraint: string
        if (!is_null($applyApprovalRules) && !is_string($applyApprovalRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applyApprovalRules)), __LINE__);
        }
        $this->ApplyApprovalRules = $applyApprovalRules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCorporateSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
