<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corporate StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCorporate extends DgOrganization
{
    /**
     * The ModifyProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ModifyProfile;
    /**
     * The AgencyCommissionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $AgencyCommissionID;
    /**
     * The AgencySecondaryLevelServiceFeeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $AgencySecondaryLevelServiceFeeID;
    /**
     * The GroupCommissionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $GroupCommissionID;
    /**
     * The AgencyGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $AgencyGroupID;
    /**
     * The SubAgencyUseParentCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SubAgencyUseParentCommission;
    /**
     * The SubAgencyUseParentServiceFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SubAgencyUseParentServiceFee;
    /**
     * The GroupUseParentCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GroupUseParentCommission;
    /**
     * The GroupUseParentServiceFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GroupUseParentServiceFee;
    /**
     * The HomeOfficeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomeOfficeID;
    /**
     * The AwayOfficeIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString5
     */
    public $AwayOfficeIDs;
    /**
     * The CrossBorderSearchLogic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CrossBorderSearchLogic;
    /**
     * The CBSSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCrossBoarderSearchSetting
     */
    public $CBSSettings;
    /**
     * The B2CRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString5
     */
    public $B2CRules;
    /**
     * The Theme
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Theme;
    /**
     * The Master
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Master;
    /**
     * The FareCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString5
     */
    public $FareCodes;
    /**
     * The CorporateSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCorporateSetting
     */
    public $CorporateSettings;
    /**
     * The QueueSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfQueueSetting
     */
    public $QueueSettings;
    /**
     * The GroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * Constructor method for Corporate
     * @uses DgCorporate::setModifyProfile()
     * @uses DgCorporate::setAgencyCommissionID()
     * @uses DgCorporate::setAgencySecondaryLevelServiceFeeID()
     * @uses DgCorporate::setGroupCommissionID()
     * @uses DgCorporate::setAgencyGroupID()
     * @uses DgCorporate::setSubAgencyUseParentCommission()
     * @uses DgCorporate::setSubAgencyUseParentServiceFee()
     * @uses DgCorporate::setGroupUseParentCommission()
     * @uses DgCorporate::setGroupUseParentServiceFee()
     * @uses DgCorporate::setHomeOfficeID()
     * @uses DgCorporate::setAwayOfficeIDs()
     * @uses DgCorporate::setCrossBorderSearchLogic()
     * @uses DgCorporate::setCBSSettings()
     * @uses DgCorporate::setB2CRules()
     * @uses DgCorporate::setTheme()
     * @uses DgCorporate::setMaster()
     * @uses DgCorporate::setFareCodes()
     * @uses DgCorporate::setCorporateSettings()
     * @uses DgCorporate::setQueueSettings()
     * @uses DgCorporate::setGroupName()
     * @param bool $modifyProfile
     * @param string $agencyCommissionID
     * @param string $agencySecondaryLevelServiceFeeID
     * @param string $groupCommissionID
     * @param string $agencyGroupID
     * @param bool $subAgencyUseParentCommission
     * @param bool $subAgencyUseParentServiceFee
     * @param bool $groupUseParentCommission
     * @param bool $groupUseParentServiceFee
     * @param string $homeOfficeID
     * @param \dgsoft\ArrayType\DgArrayOfString5 $awayOfficeIDs
     * @param string $crossBorderSearchLogic
     * @param \dgsoft\StructType\DgCrossBoarderSearchSetting $cBSSettings
     * @param \dgsoft\ArrayType\DgArrayOfString5 $b2CRules
     * @param string $theme
     * @param string $master
     * @param \dgsoft\ArrayType\DgArrayOfString5 $fareCodes
     * @param \dgsoft\ArrayType\DgArrayOfCorporateSetting $corporateSettings
     * @param \dgsoft\ArrayType\DgArrayOfQueueSetting $queueSettings
     * @param string $groupName
     */
    public function __construct($modifyProfile = null, $agencyCommissionID = null, $agencySecondaryLevelServiceFeeID = null, $groupCommissionID = null, $agencyGroupID = null, $subAgencyUseParentCommission = null, $subAgencyUseParentServiceFee = null, $groupUseParentCommission = null, $groupUseParentServiceFee = null, $homeOfficeID = null, \dgsoft\ArrayType\DgArrayOfString5 $awayOfficeIDs = null, $crossBorderSearchLogic = null, \dgsoft\StructType\DgCrossBoarderSearchSetting $cBSSettings = null, \dgsoft\ArrayType\DgArrayOfString5 $b2CRules = null, $theme = null, $master = null, \dgsoft\ArrayType\DgArrayOfString5 $fareCodes = null, \dgsoft\ArrayType\DgArrayOfCorporateSetting $corporateSettings = null, \dgsoft\ArrayType\DgArrayOfQueueSetting $queueSettings = null, $groupName = null)
    {
        $this
            ->setModifyProfile($modifyProfile)
            ->setAgencyCommissionID($agencyCommissionID)
            ->setAgencySecondaryLevelServiceFeeID($agencySecondaryLevelServiceFeeID)
            ->setGroupCommissionID($groupCommissionID)
            ->setAgencyGroupID($agencyGroupID)
            ->setSubAgencyUseParentCommission($subAgencyUseParentCommission)
            ->setSubAgencyUseParentServiceFee($subAgencyUseParentServiceFee)
            ->setGroupUseParentCommission($groupUseParentCommission)
            ->setGroupUseParentServiceFee($groupUseParentServiceFee)
            ->setHomeOfficeID($homeOfficeID)
            ->setAwayOfficeIDs($awayOfficeIDs)
            ->setCrossBorderSearchLogic($crossBorderSearchLogic)
            ->setCBSSettings($cBSSettings)
            ->setB2CRules($b2CRules)
            ->setTheme($theme)
            ->setMaster($master)
            ->setFareCodes($fareCodes)
            ->setCorporateSettings($corporateSettings)
            ->setQueueSettings($queueSettings)
            ->setGroupName($groupName);
    }
    /**
     * Get ModifyProfile value
     * @return bool
     */
    public function getModifyProfile()
    {
        return $this->ModifyProfile;
    }
    /**
     * Set ModifyProfile value
     * @param bool $modifyProfile
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setModifyProfile($modifyProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyProfile) && !is_bool($modifyProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($modifyProfile)), __LINE__);
        }
        $this->ModifyProfile = $modifyProfile;
        return $this;
    }
    /**
     * Get AgencyCommissionID value
     * @return string
     */
    public function getAgencyCommissionID()
    {
        return $this->AgencyCommissionID;
    }
    /**
     * Set AgencyCommissionID value
     * @param string $agencyCommissionID
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setAgencyCommissionID($agencyCommissionID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($agencyCommissionID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $agencyCommissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($agencyCommissionID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agencyCommissionID) && !is_string($agencyCommissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyCommissionID)), __LINE__);
        }
        $this->AgencyCommissionID = $agencyCommissionID;
        return $this;
    }
    /**
     * Get AgencySecondaryLevelServiceFeeID value
     * @return string
     */
    public function getAgencySecondaryLevelServiceFeeID()
    {
        return $this->AgencySecondaryLevelServiceFeeID;
    }
    /**
     * Set AgencySecondaryLevelServiceFeeID value
     * @param string $agencySecondaryLevelServiceFeeID
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setAgencySecondaryLevelServiceFeeID($agencySecondaryLevelServiceFeeID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($agencySecondaryLevelServiceFeeID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $agencySecondaryLevelServiceFeeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($agencySecondaryLevelServiceFeeID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agencySecondaryLevelServiceFeeID) && !is_string($agencySecondaryLevelServiceFeeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencySecondaryLevelServiceFeeID)), __LINE__);
        }
        $this->AgencySecondaryLevelServiceFeeID = $agencySecondaryLevelServiceFeeID;
        return $this;
    }
    /**
     * Get GroupCommissionID value
     * @return string
     */
    public function getGroupCommissionID()
    {
        return $this->GroupCommissionID;
    }
    /**
     * Set GroupCommissionID value
     * @param string $groupCommissionID
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setGroupCommissionID($groupCommissionID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($groupCommissionID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $groupCommissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($groupCommissionID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groupCommissionID) && !is_string($groupCommissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCommissionID)), __LINE__);
        }
        $this->GroupCommissionID = $groupCommissionID;
        return $this;
    }
    /**
     * Get AgencyGroupID value
     * @return string
     */
    public function getAgencyGroupID()
    {
        return $this->AgencyGroupID;
    }
    /**
     * Set AgencyGroupID value
     * @param string $agencyGroupID
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setAgencyGroupID($agencyGroupID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($agencyGroupID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $agencyGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($agencyGroupID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agencyGroupID) && !is_string($agencyGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyGroupID)), __LINE__);
        }
        $this->AgencyGroupID = $agencyGroupID;
        return $this;
    }
    /**
     * Get SubAgencyUseParentCommission value
     * @return bool
     */
    public function getSubAgencyUseParentCommission()
    {
        return $this->SubAgencyUseParentCommission;
    }
    /**
     * Set SubAgencyUseParentCommission value
     * @param bool $subAgencyUseParentCommission
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setSubAgencyUseParentCommission($subAgencyUseParentCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($subAgencyUseParentCommission) && !is_bool($subAgencyUseParentCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subAgencyUseParentCommission)), __LINE__);
        }
        $this->SubAgencyUseParentCommission = $subAgencyUseParentCommission;
        return $this;
    }
    /**
     * Get SubAgencyUseParentServiceFee value
     * @return bool
     */
    public function getSubAgencyUseParentServiceFee()
    {
        return $this->SubAgencyUseParentServiceFee;
    }
    /**
     * Set SubAgencyUseParentServiceFee value
     * @param bool $subAgencyUseParentServiceFee
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setSubAgencyUseParentServiceFee($subAgencyUseParentServiceFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($subAgencyUseParentServiceFee) && !is_bool($subAgencyUseParentServiceFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subAgencyUseParentServiceFee)), __LINE__);
        }
        $this->SubAgencyUseParentServiceFee = $subAgencyUseParentServiceFee;
        return $this;
    }
    /**
     * Get GroupUseParentCommission value
     * @return bool
     */
    public function getGroupUseParentCommission()
    {
        return $this->GroupUseParentCommission;
    }
    /**
     * Set GroupUseParentCommission value
     * @param bool $groupUseParentCommission
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setGroupUseParentCommission($groupUseParentCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupUseParentCommission) && !is_bool($groupUseParentCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($groupUseParentCommission)), __LINE__);
        }
        $this->GroupUseParentCommission = $groupUseParentCommission;
        return $this;
    }
    /**
     * Get GroupUseParentServiceFee value
     * @return bool
     */
    public function getGroupUseParentServiceFee()
    {
        return $this->GroupUseParentServiceFee;
    }
    /**
     * Set GroupUseParentServiceFee value
     * @param bool $groupUseParentServiceFee
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setGroupUseParentServiceFee($groupUseParentServiceFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupUseParentServiceFee) && !is_bool($groupUseParentServiceFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($groupUseParentServiceFee)), __LINE__);
        }
        $this->GroupUseParentServiceFee = $groupUseParentServiceFee;
        return $this;
    }
    /**
     * Get HomeOfficeID value
     * @return string|null
     */
    public function getHomeOfficeID()
    {
        return $this->HomeOfficeID;
    }
    /**
     * Set HomeOfficeID value
     * @param string $homeOfficeID
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setHomeOfficeID($homeOfficeID = null)
    {
        // validation for constraint: string
        if (!is_null($homeOfficeID) && !is_string($homeOfficeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeOfficeID)), __LINE__);
        }
        $this->HomeOfficeID = $homeOfficeID;
        return $this;
    }
    /**
     * Get AwayOfficeIDs value
     * @return \dgsoft\ArrayType\DgArrayOfString5|null
     */
    public function getAwayOfficeIDs()
    {
        return $this->AwayOfficeIDs;
    }
    /**
     * Set AwayOfficeIDs value
     * @param \dgsoft\ArrayType\DgArrayOfString5 $awayOfficeIDs
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setAwayOfficeIDs(\dgsoft\ArrayType\DgArrayOfString5 $awayOfficeIDs = null)
    {
        $this->AwayOfficeIDs = $awayOfficeIDs;
        return $this;
    }
    /**
     * Get CrossBorderSearchLogic value
     * @return string|null
     */
    public function getCrossBorderSearchLogic()
    {
        return $this->CrossBorderSearchLogic;
    }
    /**
     * Set CrossBorderSearchLogic value
     * @param string $crossBorderSearchLogic
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setCrossBorderSearchLogic($crossBorderSearchLogic = null)
    {
        // validation for constraint: string
        if (!is_null($crossBorderSearchLogic) && !is_string($crossBorderSearchLogic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($crossBorderSearchLogic)), __LINE__);
        }
        $this->CrossBorderSearchLogic = $crossBorderSearchLogic;
        return $this;
    }
    /**
     * Get CBSSettings value
     * @return \dgsoft\StructType\DgCrossBoarderSearchSetting|null
     */
    public function getCBSSettings()
    {
        return $this->CBSSettings;
    }
    /**
     * Set CBSSettings value
     * @param \dgsoft\StructType\DgCrossBoarderSearchSetting $cBSSettings
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setCBSSettings(\dgsoft\StructType\DgCrossBoarderSearchSetting $cBSSettings = null)
    {
        $this->CBSSettings = $cBSSettings;
        return $this;
    }
    /**
     * Get B2CRules value
     * @return \dgsoft\ArrayType\DgArrayOfString5|null
     */
    public function getB2CRules()
    {
        return $this->B2CRules;
    }
    /**
     * Set B2CRules value
     * @param \dgsoft\ArrayType\DgArrayOfString5 $b2CRules
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setB2CRules(\dgsoft\ArrayType\DgArrayOfString5 $b2CRules = null)
    {
        $this->B2CRules = $b2CRules;
        return $this;
    }
    /**
     * Get Theme value
     * @return string|null
     */
    public function getTheme()
    {
        return $this->Theme;
    }
    /**
     * Set Theme value
     * @param string $theme
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setTheme($theme = null)
    {
        // validation for constraint: string
        if (!is_null($theme) && !is_string($theme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($theme)), __LINE__);
        }
        $this->Theme = $theme;
        return $this;
    }
    /**
     * Get Master value
     * @return string|null
     */
    public function getMaster()
    {
        return $this->Master;
    }
    /**
     * Set Master value
     * @param string $master
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setMaster($master = null)
    {
        // validation for constraint: string
        if (!is_null($master) && !is_string($master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($master)), __LINE__);
        }
        $this->Master = $master;
        return $this;
    }
    /**
     * Get FareCodes value
     * @return \dgsoft\ArrayType\DgArrayOfString5|null
     */
    public function getFareCodes()
    {
        return $this->FareCodes;
    }
    /**
     * Set FareCodes value
     * @param \dgsoft\ArrayType\DgArrayOfString5 $fareCodes
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setFareCodes(\dgsoft\ArrayType\DgArrayOfString5 $fareCodes = null)
    {
        $this->FareCodes = $fareCodes;
        return $this;
    }
    /**
     * Get CorporateSettings value
     * @return \dgsoft\ArrayType\DgArrayOfCorporateSetting|null
     */
    public function getCorporateSettings()
    {
        return $this->CorporateSettings;
    }
    /**
     * Set CorporateSettings value
     * @param \dgsoft\ArrayType\DgArrayOfCorporateSetting $corporateSettings
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setCorporateSettings(\dgsoft\ArrayType\DgArrayOfCorporateSetting $corporateSettings = null)
    {
        $this->CorporateSettings = $corporateSettings;
        return $this;
    }
    /**
     * Get QueueSettings value
     * @return \dgsoft\ArrayType\DgArrayOfQueueSetting|null
     */
    public function getQueueSettings()
    {
        return $this->QueueSettings;
    }
    /**
     * Set QueueSettings value
     * @param \dgsoft\ArrayType\DgArrayOfQueueSetting $queueSettings
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setQueueSettings(\dgsoft\ArrayType\DgArrayOfQueueSetting $queueSettings = null)
    {
        $this->QueueSettings = $queueSettings;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \dgsoft\StructType\DgCorporate
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCorporate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
