<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPersonType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgContactPersonType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephone[]
     */
    public $Telephone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType[]
     */
    public $Address;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmailType[]
     */
    public $Email;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgURL_Type[]
     */
    public $URL;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $CompanyName;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DefaultInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The ContactType
     * @var string
     */
    public $ContactType;
    /**
     * The Relation
     * @var string
     */
    public $Relation;
    /**
     * The EmergencyFlag
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $EmergencyFlag;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The CommunicationMethodCode
     * @var string
     */
    public $CommunicationMethodCode;
    /**
     * The DocumentDistribMethodCode
     * @var string
     */
    public $DocumentDistribMethodCode;
    /**
     * Constructor method for ContactPersonType
     * @uses DgContactPersonType::setPersonName()
     * @uses DgContactPersonType::setTelephone()
     * @uses DgContactPersonType::setAddress()
     * @uses DgContactPersonType::setEmail()
     * @uses DgContactPersonType::setURL()
     * @uses DgContactPersonType::setCompanyName()
     * @uses DgContactPersonType::setEmployeeInfo()
     * @uses DgContactPersonType::setShareSynchInd()
     * @uses DgContactPersonType::setShareMarketInd()
     * @uses DgContactPersonType::setDefaultInd()
     * @uses DgContactPersonType::setContactType()
     * @uses DgContactPersonType::setRelation()
     * @uses DgContactPersonType::setEmergencyFlag()
     * @uses DgContactPersonType::setRPH()
     * @uses DgContactPersonType::setCommunicationMethodCode()
     * @uses DgContactPersonType::setDocumentDistribMethodCode()
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @param \dgsoft\StructType\DgAddressInfoType[] $address
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @param \dgsoft\StructType\DgURL_Type[] $uRL
     * @param \dgsoft\StructType\DgCompanyNameType[] $companyName
     * @param \dgsoft\StructType\DgEmployeeInfoType[] $employeeInfo
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $defaultInd
     * @param string $contactType
     * @param string $relation
     * @param bool $emergencyFlag
     * @param string $rPH
     * @param string $communicationMethodCode
     * @param string $documentDistribMethodCode
     */
    public function __construct(\dgsoft\StructType\DgPersonNameType $personName = null, array $telephone = array(), array $address = array(), array $email = array(), array $uRL = array(), array $companyName = array(), array $employeeInfo = array(), $shareSynchInd = null, $shareMarketInd = null, $defaultInd = false, $contactType = null, $relation = null, $emergencyFlag = false, $rPH = null, $communicationMethodCode = null, $documentDistribMethodCode = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setAddress($address)
            ->setEmail($email)
            ->setURL($uRL)
            ->setCompanyName($companyName)
            ->setEmployeeInfo($employeeInfo)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDefaultInd($defaultInd)
            ->setContactType($contactType)
            ->setRelation($relation)
            ->setEmergencyFlag($emergencyFlag)
            ->setRPH($rPH)
            ->setCommunicationMethodCode($communicationMethodCode)
            ->setDocumentDistribMethodCode($documentDistribMethodCode);
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $contactPersonTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeTelephoneItem instanceof \dgsoft\StructType\DgTelephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($contactPersonTypeTelephoneItem) ? get_class($contactPersonTypeTelephoneItem) : gettype($contactPersonTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone $item
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function addToTelephone(\dgsoft\StructType\DgTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddressInfoType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType[] $address
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $contactPersonTypeAddressItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeAddressItem instanceof \dgsoft\StructType\DgAddressInfoType) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($contactPersonTypeAddressItem) ? get_class($contactPersonTypeAddressItem) : gettype($contactPersonTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType $item
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function addToAddress(\dgsoft\StructType\DgAddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \dgsoft\StructType\DgEmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $contactPersonTypeEmailItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeEmailItem instanceof \dgsoft\StructType\DgEmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($contactPersonTypeEmailItem) ? get_class($contactPersonTypeEmailItem) : gettype($contactPersonTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType $item
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function addToEmail(\dgsoft\StructType\DgEmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \dgsoft\StructType\DgURL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgURL_Type[] $uRL
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setURL(array $uRL = array())
    {
        foreach ($uRL as $contactPersonTypeURLItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeURLItem instanceof \dgsoft\StructType\DgURL_Type) {
                throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \dgsoft\StructType\DgURL_Type, "%s" given', is_object($contactPersonTypeURLItem) ? get_class($contactPersonTypeURLItem) : gettype($contactPersonTypeURLItem)), __LINE__);
            }
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgURL_Type $item
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function addToURL(\dgsoft\StructType\DgURL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgURL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \dgsoft\StructType\DgURL_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $companyName
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setCompanyName(array $companyName = array())
    {
        foreach ($companyName as $contactPersonTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeCompanyNameItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($contactPersonTypeCompanyNameItem) ? get_class($contactPersonTypeCompanyNameItem) : gettype($contactPersonTypeCompanyNameItem)), __LINE__);
            }
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function addToCompanyName(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \dgsoft\StructType\DgEmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployeeInfoType[] $employeeInfo
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $contactPersonTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeEmployeeInfoItem instanceof \dgsoft\StructType\DgEmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \dgsoft\StructType\DgEmployeeInfoType, "%s" given', is_object($contactPersonTypeEmployeeInfoItem) ? get_class($contactPersonTypeEmployeeInfoItem) : gettype($contactPersonTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployeeInfoType $item
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function addToEmployeeInfo(\dgsoft\StructType\DgEmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \dgsoft\StructType\DgEmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param string $contactType
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: string
        if (!is_null($contactType) && !is_string($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactType)), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get Relation value
     * @return string|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get EmergencyFlag value
     * @return bool|null
     */
    public function getEmergencyFlag()
    {
        return $this->EmergencyFlag;
    }
    /**
     * Set EmergencyFlag value
     * @param bool $emergencyFlag
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setEmergencyFlag($emergencyFlag = false)
    {
        // validation for constraint: boolean
        if (!is_null($emergencyFlag) && !is_bool($emergencyFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emergencyFlag)), __LINE__);
        }
        $this->EmergencyFlag = $emergencyFlag;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get CommunicationMethodCode value
     * @return string|null
     */
    public function getCommunicationMethodCode()
    {
        return $this->CommunicationMethodCode;
    }
    /**
     * Set CommunicationMethodCode value
     * @param string $communicationMethodCode
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setCommunicationMethodCode($communicationMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($communicationMethodCode) && !is_string($communicationMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationMethodCode)), __LINE__);
        }
        $this->CommunicationMethodCode = $communicationMethodCode;
        return $this;
    }
    /**
     * Get DocumentDistribMethodCode value
     * @return string|null
     */
    public function getDocumentDistribMethodCode()
    {
        return $this->DocumentDistribMethodCode;
    }
    /**
     * Set DocumentDistribMethodCode value
     * @param string $documentDistribMethodCode
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public function setDocumentDistribMethodCode($documentDistribMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentDistribMethodCode) && !is_string($documentDistribMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentDistribMethodCode)), __LINE__);
        }
        $this->DocumentDistribMethodCode = $documentDistribMethodCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgContactPersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
