<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCompanyInfoType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $CompanyName;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType[]
     */
    public $AddressInfo;
    /**
     * The TelephoneInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephoneInfo[]
     */
    public $TelephoneInfo;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmailType[]
     */
    public $Email;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgURL_Type[]
     */
    public $URL;
    /**
     * The BusinessLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType[]
     */
    public $BusinessLocale;
    /**
     * The PaymentForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The ContactPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * Constructor method for CompanyInfoType
     * @uses DgCompanyInfoType::setCompanyName()
     * @uses DgCompanyInfoType::setAddressInfo()
     * @uses DgCompanyInfoType::setTelephoneInfo()
     * @uses DgCompanyInfoType::setEmail()
     * @uses DgCompanyInfoType::setURL()
     * @uses DgCompanyInfoType::setBusinessLocale()
     * @uses DgCompanyInfoType::setPaymentForm()
     * @uses DgCompanyInfoType::setContactPerson()
     * @uses DgCompanyInfoType::setTravelArranger()
     * @uses DgCompanyInfoType::setLoyaltyProgram()
     * @param \dgsoft\StructType\DgCompanyNameType[] $companyName
     * @param \dgsoft\StructType\DgAddressInfoType[] $addressInfo
     * @param \dgsoft\StructType\DgTelephoneInfo[] $telephoneInfo
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @param \dgsoft\StructType\DgURL_Type[] $uRL
     * @param \dgsoft\StructType\DgAddressType[] $businessLocale
     * @param \dgsoft\StructType\DgPaymentFormType[] $paymentForm
     * @param \dgsoft\StructType\DgContactPersonType[] $contactPerson
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @param \dgsoft\StructType\DgLoyaltyProgramType[] $loyaltyProgram
     */
    public function __construct(array $companyName = array(), array $addressInfo = array(), array $telephoneInfo = array(), array $email = array(), array $uRL = array(), array $businessLocale = array(), array $paymentForm = array(), array $contactPerson = array(), array $travelArranger = array(), array $loyaltyProgram = array())
    {
        $this
            ->setCompanyName($companyName)
            ->setAddressInfo($addressInfo)
            ->setTelephoneInfo($telephoneInfo)
            ->setEmail($email)
            ->setURL($uRL)
            ->setBusinessLocale($businessLocale)
            ->setPaymentForm($paymentForm)
            ->setContactPerson($contactPerson)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram);
    }
    /**
     * Get CompanyName value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $companyName
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setCompanyName(array $companyName = array())
    {
        foreach ($companyName as $companyInfoTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeCompanyNameItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($companyInfoTypeCompanyNameItem) ? get_class($companyInfoTypeCompanyNameItem) : gettype($companyInfoTypeCompanyNameItem)), __LINE__);
            }
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToCompanyName(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \dgsoft\StructType\DgAddressInfoType[]|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType[] $addressInfo
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setAddressInfo(array $addressInfo = array())
    {
        foreach ($addressInfo as $companyInfoTypeAddressInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeAddressInfoItem instanceof \dgsoft\StructType\DgAddressInfoType) {
                throw new \InvalidArgumentException(sprintf('The AddressInfo property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($companyInfoTypeAddressInfoItem) ? get_class($companyInfoTypeAddressInfoItem) : gettype($companyInfoTypeAddressInfoItem)), __LINE__);
            }
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Add item to AddressInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressInfoType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToAddressInfo(\dgsoft\StructType\DgAddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The AddressInfo property can only contain items of \dgsoft\StructType\DgAddressInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressInfo[] = $item;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \dgsoft\StructType\DgTelephoneInfo[]|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * Set TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephoneInfo[] $telephoneInfo
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setTelephoneInfo(array $telephoneInfo = array())
    {
        foreach ($telephoneInfo as $companyInfoTypeTelephoneInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTelephoneInfoItem instanceof \dgsoft\StructType\DgTelephoneInfo) {
                throw new \InvalidArgumentException(sprintf('The TelephoneInfo property can only contain items of \dgsoft\StructType\DgTelephoneInfo, "%s" given', is_object($companyInfoTypeTelephoneInfoItem) ? get_class($companyInfoTypeTelephoneInfoItem) : gettype($companyInfoTypeTelephoneInfoItem)), __LINE__);
            }
        }
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Add item to TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephoneInfo $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToTelephoneInfo(\dgsoft\StructType\DgTelephoneInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTelephoneInfo) {
            throw new \InvalidArgumentException(sprintf('The TelephoneInfo property can only contain items of \dgsoft\StructType\DgTelephoneInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TelephoneInfo[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \dgsoft\StructType\DgEmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType[] $email
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $companyInfoTypeEmailItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeEmailItem instanceof \dgsoft\StructType\DgEmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($companyInfoTypeEmailItem) ? get_class($companyInfoTypeEmailItem) : gettype($companyInfoTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmailType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToEmail(\dgsoft\StructType\DgEmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \dgsoft\StructType\DgURL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgURL_Type[] $uRL
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setURL(array $uRL = array())
    {
        foreach ($uRL as $companyInfoTypeURLItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeURLItem instanceof \dgsoft\StructType\DgURL_Type) {
                throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \dgsoft\StructType\DgURL_Type, "%s" given', is_object($companyInfoTypeURLItem) ? get_class($companyInfoTypeURLItem) : gettype($companyInfoTypeURLItem)), __LINE__);
            }
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgURL_Type $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToURL(\dgsoft\StructType\DgURL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgURL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \dgsoft\StructType\DgURL_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get BusinessLocale value
     * @return \dgsoft\StructType\DgAddressType[]|null
     */
    public function getBusinessLocale()
    {
        return $this->BusinessLocale;
    }
    /**
     * Set BusinessLocale value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressType[] $businessLocale
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setBusinessLocale(array $businessLocale = array())
    {
        foreach ($businessLocale as $companyInfoTypeBusinessLocaleItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeBusinessLocaleItem instanceof \dgsoft\StructType\DgAddressType) {
                throw new \InvalidArgumentException(sprintf('The BusinessLocale property can only contain items of \dgsoft\StructType\DgAddressType, "%s" given', is_object($companyInfoTypeBusinessLocaleItem) ? get_class($companyInfoTypeBusinessLocaleItem) : gettype($companyInfoTypeBusinessLocaleItem)), __LINE__);
            }
        }
        $this->BusinessLocale = $businessLocale;
        return $this;
    }
    /**
     * Add item to BusinessLocale value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToBusinessLocale(\dgsoft\StructType\DgAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressType) {
            throw new \InvalidArgumentException(sprintf('The BusinessLocale property can only contain items of \dgsoft\StructType\DgAddressType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessLocale[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \dgsoft\StructType\DgPaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormType[] $paymentForm
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        foreach ($paymentForm as $companyInfoTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypePaymentFormItem instanceof \dgsoft\StructType\DgPaymentFormType) {
                throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \dgsoft\StructType\DgPaymentFormType, "%s" given', is_object($companyInfoTypePaymentFormItem) ? get_class($companyInfoTypePaymentFormItem) : gettype($companyInfoTypePaymentFormItem)), __LINE__);
            }
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToPaymentForm(\dgsoft\StructType\DgPaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \dgsoft\StructType\DgPaymentFormType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \dgsoft\StructType\DgContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactPersonType[] $contactPerson
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        foreach ($contactPerson as $companyInfoTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeContactPersonItem instanceof \dgsoft\StructType\DgContactPersonType) {
                throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \dgsoft\StructType\DgContactPersonType, "%s" given', is_object($companyInfoTypeContactPersonItem) ? get_class($companyInfoTypeContactPersonItem) : gettype($companyInfoTypeContactPersonItem)), __LINE__);
            }
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgContactPersonType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToContactPerson(\dgsoft\StructType\DgContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \dgsoft\StructType\DgContactPersonType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \dgsoft\StructType\DgTravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $companyInfoTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTravelArrangerItem instanceof \dgsoft\StructType\DgTravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($companyInfoTypeTravelArrangerItem) ? get_class($companyInfoTypeTravelArrangerItem) : gettype($companyInfoTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToTravelArranger(\dgsoft\StructType\DgTravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \dgsoft\StructType\DgLoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyProgramType[] $loyaltyProgram
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        foreach ($loyaltyProgram as $companyInfoTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeLoyaltyProgramItem instanceof \dgsoft\StructType\DgLoyaltyProgramType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \dgsoft\StructType\DgLoyaltyProgramType, "%s" given', is_object($companyInfoTypeLoyaltyProgramItem) ? get_class($companyInfoTypeLoyaltyProgramItem) : gettype($companyInfoTypeLoyaltyProgramItem)), __LINE__);
            }
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyProgramType $item
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public function addToLoyaltyProgram(\dgsoft\StructType\DgLoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \dgsoft\StructType\DgLoyaltyProgramType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCompanyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
