<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Communication StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCommunication extends DgDBBaseEntity
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityID;
    /**
     * The CommunicationMediaCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationMediaCode;
    /**
     * The ValueText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValueText;
    /**
     * The PhoneCountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneCountryCode;
    /**
     * The PhoneAreaCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneAreaCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for Communication
     * @uses DgCommunication::setEntityID()
     * @uses DgCommunication::setCommunicationMediaCode()
     * @uses DgCommunication::setValueText()
     * @uses DgCommunication::setPhoneCountryCode()
     * @uses DgCommunication::setPhoneAreaCode()
     * @uses DgCommunication::setPhoneNumber()
     * @param string $entityID
     * @param string $communicationMediaCode
     * @param string $valueText
     * @param string $phoneCountryCode
     * @param string $phoneAreaCode
     * @param string $phoneNumber
     */
    public function __construct($entityID = null, $communicationMediaCode = null, $valueText = null, $phoneCountryCode = null, $phoneAreaCode = null, $phoneNumber = null)
    {
        $this
            ->setEntityID($entityID)
            ->setCommunicationMediaCode($communicationMediaCode)
            ->setValueText($valueText)
            ->setPhoneCountryCode($phoneCountryCode)
            ->setPhoneAreaCode($phoneAreaCode)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get EntityID value
     * @return string
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \dgsoft\StructType\DgCommunication
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($entityID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($entityID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get CommunicationMediaCode value
     * @return string|null
     */
    public function getCommunicationMediaCode()
    {
        return $this->CommunicationMediaCode;
    }
    /**
     * Set CommunicationMediaCode value
     * @param string $communicationMediaCode
     * @return \dgsoft\StructType\DgCommunication
     */
    public function setCommunicationMediaCode($communicationMediaCode = null)
    {
        // validation for constraint: string
        if (!is_null($communicationMediaCode) && !is_string($communicationMediaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationMediaCode)), __LINE__);
        }
        $this->CommunicationMediaCode = $communicationMediaCode;
        return $this;
    }
    /**
     * Get ValueText value
     * @return string|null
     */
    public function getValueText()
    {
        return $this->ValueText;
    }
    /**
     * Set ValueText value
     * @param string $valueText
     * @return \dgsoft\StructType\DgCommunication
     */
    public function setValueText($valueText = null)
    {
        // validation for constraint: string
        if (!is_null($valueText) && !is_string($valueText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valueText)), __LINE__);
        }
        $this->ValueText = $valueText;
        return $this;
    }
    /**
     * Get PhoneCountryCode value
     * @return string|null
     */
    public function getPhoneCountryCode()
    {
        return $this->PhoneCountryCode;
    }
    /**
     * Set PhoneCountryCode value
     * @param string $phoneCountryCode
     * @return \dgsoft\StructType\DgCommunication
     */
    public function setPhoneCountryCode($phoneCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneCountryCode) && !is_string($phoneCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneCountryCode)), __LINE__);
        }
        $this->PhoneCountryCode = $phoneCountryCode;
        return $this;
    }
    /**
     * Get PhoneAreaCode value
     * @return string|null
     */
    public function getPhoneAreaCode()
    {
        return $this->PhoneAreaCode;
    }
    /**
     * Set PhoneAreaCode value
     * @param string $phoneAreaCode
     * @return \dgsoft\StructType\DgCommunication
     */
    public function setPhoneAreaCode($phoneAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneAreaCode) && !is_string($phoneAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneAreaCode)), __LINE__);
        }
        $this->PhoneAreaCode = $phoneAreaCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \dgsoft\StructType\DgCommunication
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCommunication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
