<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * @package Dg
 * @subpackage Structs
 */
class DgComment extends DgFormattedTextTextType
{
    /**
     * The CommentOriginatorCode
     * @var string
     */
    public $CommentOriginatorCode;
    /**
     * The GuestViewable
     * @var bool
     */
    public $GuestViewable;
    /**
     * The _
     * @var \dgsoft\StructType\DgFormattedTextTextType
     */
    public $_;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Comment
     * @uses DgComment::setCommentOriginatorCode()
     * @uses DgComment::setGuestViewable()
     * @uses DgComment::set_()
     * @uses DgComment::setName()
     * @param string $commentOriginatorCode
     * @param bool $guestViewable
     * @param \dgsoft\StructType\DgFormattedTextTextType $_
     * @param string $name
     */
    public function __construct($commentOriginatorCode = null, $guestViewable = null, \dgsoft\StructType\DgFormattedTextTextType $_ = null, $name = null)
    {
        $this
            ->setCommentOriginatorCode($commentOriginatorCode)
            ->setGuestViewable($guestViewable)
            ->set_($_)
            ->setName($name);
    }
    /**
     * Get CommentOriginatorCode value
     * @return string|null
     */
    public function getCommentOriginatorCode()
    {
        return $this->CommentOriginatorCode;
    }
    /**
     * Set CommentOriginatorCode value
     * @param string $commentOriginatorCode
     * @return \dgsoft\StructType\DgComment
     */
    public function setCommentOriginatorCode($commentOriginatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($commentOriginatorCode) && !is_string($commentOriginatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentOriginatorCode)), __LINE__);
        }
        $this->CommentOriginatorCode = $commentOriginatorCode;
        return $this;
    }
    /**
     * Get GuestViewable value
     * @return bool|null
     */
    public function getGuestViewable()
    {
        return $this->GuestViewable;
    }
    /**
     * Set GuestViewable value
     * @param bool $guestViewable
     * @return \dgsoft\StructType\DgComment
     */
    public function setGuestViewable($guestViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($guestViewable) && !is_bool($guestViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guestViewable)), __LINE__);
        }
        $this->GuestViewable = $guestViewable;
        return $this;
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgFormattedTextTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgFormattedTextTextType $_
     * @return \dgsoft\StructType\DgComment
     */
    public function set_(\dgsoft\StructType\DgFormattedTextTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \dgsoft\StructType\DgComment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
