<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeRef StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCodeRef extends DgLocationType
{
    /**
     * The VendorID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $VendorID;
    /**
     * The _
     * @var \dgsoft\StructType\DgLocationType
     */
    public $_;
    /**
     * The VicinityCode
     * @var string
     */
    public $VicinityCode;
    /**
     * Constructor method for CodeRef
     * @uses DgCodeRef::setVendorID()
     * @uses DgCodeRef::set_()
     * @uses DgCodeRef::setVicinityCode()
     * @param int $vendorID
     * @param \dgsoft\StructType\DgLocationType $_
     * @param string $vicinityCode
     */
    public function __construct($vendorID = null, \dgsoft\StructType\DgLocationType $_ = null, $vicinityCode = null)
    {
        $this
            ->setVendorID($vendorID)
            ->set_($_)
            ->setVicinityCode($vicinityCode);
    }
    /**
     * Get VendorID value
     * @return int
     */
    public function getVendorID()
    {
        return $this->VendorID;
    }
    /**
     * Set VendorID value
     * @param int $vendorID
     * @return \dgsoft\StructType\DgCodeRef
     */
    public function setVendorID($vendorID = null)
    {
        // validation for constraint: int
        if (!is_null($vendorID) && !is_numeric($vendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendorID)), __LINE__);
        }
        $this->VendorID = $vendorID;
        return $this;
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgLocationType $_
     * @return \dgsoft\StructType\DgCodeRef
     */
    public function set_(\dgsoft\StructType\DgLocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get VicinityCode value
     * @return string|null
     */
    public function getVicinityCode()
    {
        return $this->VicinityCode;
    }
    /**
     * Set VicinityCode value
     * @param string $vicinityCode
     * @return \dgsoft\StructType\DgCodeRef
     */
    public function setVicinityCode($vicinityCode = null)
    {
        // validation for constraint: string
        if (!is_null($vicinityCode) && !is_string($vicinityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vicinityCode)), __LINE__);
        }
        $this->VicinityCode = $vicinityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCodeRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
