<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckoutCharge StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCheckoutCharge extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The NmbrOfNights
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The BalanceOfStayInd
     * @var bool
     */
    public $BalanceOfStayInd;
    /**
     * Constructor method for CheckoutCharge
     * @uses DgCheckoutCharge::setAmount()
     * @uses DgCheckoutCharge::setPercent()
     * @uses DgCheckoutCharge::setType()
     * @uses DgCheckoutCharge::setCodeDetail()
     * @uses DgCheckoutCharge::setNmbrOfNights()
     * @uses DgCheckoutCharge::setExistsCode()
     * @uses DgCheckoutCharge::setBalanceOfStayInd()
     * @param float $amount
     * @param float $percent
     * @param string $type
     * @param string $codeDetail
     * @param int $nmbrOfNights
     * @param string $existsCode
     * @param bool $balanceOfStayInd
     */
    public function __construct($amount = null, $percent = null, $type = null, $codeDetail = null, $nmbrOfNights = null, $existsCode = null, $balanceOfStayInd = null)
    {
        $this
            ->setAmount($amount)
            ->setPercent($percent)
            ->setType($type)
            ->setCodeDetail($codeDetail)
            ->setNmbrOfNights($nmbrOfNights)
            ->setExistsCode($existsCode)
            ->setBalanceOfStayInd($balanceOfStayInd);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !is_numeric($nmbrOfNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get BalanceOfStayInd value
     * @return bool|null
     */
    public function getBalanceOfStayInd()
    {
        return $this->BalanceOfStayInd;
    }
    /**
     * Set BalanceOfStayInd value
     * @param bool $balanceOfStayInd
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public function setBalanceOfStayInd($balanceOfStayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($balanceOfStayInd) && !is_bool($balanceOfStayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($balanceOfStayInd)), __LINE__);
        }
        $this->BalanceOfStayInd = $balanceOfStayInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCheckoutCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
