<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarReservation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCarReservation extends AbstractStructBase
{
    /**
     * The VendorID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $VendorID;
    /**
     * The VehicleID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $VehicleID;
    /**
     * Constructor method for CarReservation
     * @uses DgCarReservation::setVendorID()
     * @uses DgCarReservation::setVehicleID()
     * @param int $vendorID
     * @param int $vehicleID
     */
    public function __construct($vendorID = null, $vehicleID = null)
    {
        $this
            ->setVendorID($vendorID)
            ->setVehicleID($vehicleID);
    }
    /**
     * Get VendorID value
     * @return int
     */
    public function getVendorID()
    {
        return $this->VendorID;
    }
    /**
     * Set VendorID value
     * @param int $vendorID
     * @return \dgsoft\StructType\DgCarReservation
     */
    public function setVendorID($vendorID = null)
    {
        // validation for constraint: int
        if (!is_null($vendorID) && !is_numeric($vendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendorID)), __LINE__);
        }
        $this->VendorID = $vendorID;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return int
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param int $vehicleID
     * @return \dgsoft\StructType\DgCarReservation
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleID) && !is_numeric($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCarReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
