<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelRuleType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCancelRuleType extends AbstractStructBase
{
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentCardType
     */
    public $PaymentCard;
    /**
     * The CancelByDate
     * @var string
     */
    public $CancelByDate;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for CancelRuleType
     * @uses DgCancelRuleType::setPaymentCard()
     * @uses DgCancelRuleType::setCancelByDate()
     * @uses DgCancelRuleType::setAmount()
     * @uses DgCancelRuleType::setPercent()
     * @uses DgCancelRuleType::setType()
     * @param \dgsoft\StructType\DgPaymentCardType $paymentCard
     * @param string $cancelByDate
     * @param float $amount
     * @param float $percent
     * @param string $type
     */
    public function __construct(\dgsoft\StructType\DgPaymentCardType $paymentCard = null, $cancelByDate = null, $amount = null, $percent = null, $type = null)
    {
        $this
            ->setPaymentCard($paymentCard)
            ->setCancelByDate($cancelByDate)
            ->setAmount($amount)
            ->setPercent($percent)
            ->setType($type);
    }
    /**
     * Get PaymentCard value
     * @return \dgsoft\StructType\DgPaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \dgsoft\StructType\DgPaymentCardType $paymentCard
     * @return \dgsoft\StructType\DgCancelRuleType
     */
    public function setPaymentCard(\dgsoft\StructType\DgPaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get CancelByDate value
     * @return string|null
     */
    public function getCancelByDate()
    {
        return $this->CancelByDate;
    }
    /**
     * Set CancelByDate value
     * @param string $cancelByDate
     * @return \dgsoft\StructType\DgCancelRuleType
     */
    public function setCancelByDate($cancelByDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelByDate) && !is_string($cancelByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cancelByDate)), __LINE__);
        }
        $this->CancelByDate = $cancelByDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgCancelRuleType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgCancelRuleType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgCancelRuleType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCancelRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
