<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenaltyType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCancelPenaltyType extends AbstractStructBase
{
    /**
     * The Deadline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDeadline
     */
    public $Deadline;
    /**
     * The AmountPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAmountPercentType
     */
    public $AmountPercent;
    /**
     * The PenaltyDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType[]
     */
    public $PenaltyDescription;
    /**
     * The ConfirmClassCode
     * @var string
     */
    public $ConfirmClassCode;
    /**
     * The PolicyCode
     * @var string
     */
    public $PolicyCode;
    /**
     * The NonRefundable
     * @var bool
     */
    public $NonRefundable;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for CancelPenaltyType
     * @uses DgCancelPenaltyType::setDeadline()
     * @uses DgCancelPenaltyType::setAmountPercent()
     * @uses DgCancelPenaltyType::setPenaltyDescription()
     * @uses DgCancelPenaltyType::setConfirmClassCode()
     * @uses DgCancelPenaltyType::setPolicyCode()
     * @uses DgCancelPenaltyType::setNonRefundable()
     * @uses DgCancelPenaltyType::setMon()
     * @uses DgCancelPenaltyType::setTue()
     * @uses DgCancelPenaltyType::setWeds()
     * @uses DgCancelPenaltyType::setThur()
     * @uses DgCancelPenaltyType::setFri()
     * @uses DgCancelPenaltyType::setSat()
     * @uses DgCancelPenaltyType::setSun()
     * @uses DgCancelPenaltyType::setStart()
     * @uses DgCancelPenaltyType::setDuration()
     * @uses DgCancelPenaltyType::setEnd()
     * @uses DgCancelPenaltyType::setRoomTypeCode()
     * @param \dgsoft\StructType\DgDeadline $deadline
     * @param \dgsoft\StructType\DgAmountPercentType $amountPercent
     * @param \dgsoft\StructType\DgParagraphType[] $penaltyDescription
     * @param string $confirmClassCode
     * @param string $policyCode
     * @param bool $nonRefundable
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $roomTypeCode
     */
    public function __construct(\dgsoft\StructType\DgDeadline $deadline = null, \dgsoft\StructType\DgAmountPercentType $amountPercent = null, array $penaltyDescription = array(), $confirmClassCode = null, $policyCode = null, $nonRefundable = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $start = null, $duration = null, $end = null, $roomTypeCode = null)
    {
        $this
            ->setDeadline($deadline)
            ->setAmountPercent($amountPercent)
            ->setPenaltyDescription($penaltyDescription)
            ->setConfirmClassCode($confirmClassCode)
            ->setPolicyCode($policyCode)
            ->setNonRefundable($nonRefundable)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get Deadline value
     * @return \dgsoft\StructType\DgDeadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \dgsoft\StructType\DgDeadline $deadline
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setDeadline(\dgsoft\StructType\DgDeadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \dgsoft\StructType\DgAmountPercentType|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \dgsoft\StructType\DgAmountPercentType $amountPercent
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setAmountPercent(\dgsoft\StructType\DgAmountPercentType $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get PenaltyDescription value
     * @return \dgsoft\StructType\DgParagraphType[]|null
     */
    public function getPenaltyDescription()
    {
        return $this->PenaltyDescription;
    }
    /**
     * Set PenaltyDescription value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType[] $penaltyDescription
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setPenaltyDescription(array $penaltyDescription = array())
    {
        foreach ($penaltyDescription as $cancelPenaltyTypePenaltyDescriptionItem) {
            // validation for constraint: itemType
            if (!$cancelPenaltyTypePenaltyDescriptionItem instanceof \dgsoft\StructType\DgParagraphType) {
                throw new \InvalidArgumentException(sprintf('The PenaltyDescription property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($cancelPenaltyTypePenaltyDescriptionItem) ? get_class($cancelPenaltyTypePenaltyDescriptionItem) : gettype($cancelPenaltyTypePenaltyDescriptionItem)), __LINE__);
            }
        }
        $this->PenaltyDescription = $penaltyDescription;
        return $this;
    }
    /**
     * Add item to PenaltyDescription value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType $item
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function addToPenaltyDescription(\dgsoft\StructType\DgParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgParagraphType) {
            throw new \InvalidArgumentException(sprintf('The PenaltyDescription property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PenaltyDescription[] = $item;
        return $this;
    }
    /**
     * Get ConfirmClassCode value
     * @return string|null
     */
    public function getConfirmClassCode()
    {
        return $this->ConfirmClassCode;
    }
    /**
     * Set ConfirmClassCode value
     * @param string $confirmClassCode
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setConfirmClassCode($confirmClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($confirmClassCode) && !is_string($confirmClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmClassCode)), __LINE__);
        }
        $this->ConfirmClassCode = $confirmClassCode;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCancelPenaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
