<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenaltiesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCancelPenaltiesType extends AbstractStructBase
{
    /**
     * The CancelPenalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancelPenaltyType[]
     */
    public $CancelPenalty;
    /**
     * The CancelPolicyIndicator
     * @var bool
     */
    public $CancelPolicyIndicator;
    /**
     * Constructor method for CancelPenaltiesType
     * @uses DgCancelPenaltiesType::setCancelPenalty()
     * @uses DgCancelPenaltiesType::setCancelPolicyIndicator()
     * @param \dgsoft\StructType\DgCancelPenaltyType[] $cancelPenalty
     * @param bool $cancelPolicyIndicator
     */
    public function __construct(array $cancelPenalty = array(), $cancelPolicyIndicator = null)
    {
        $this
            ->setCancelPenalty($cancelPenalty)
            ->setCancelPolicyIndicator($cancelPolicyIndicator);
    }
    /**
     * Get CancelPenalty value
     * @return \dgsoft\StructType\DgCancelPenaltyType[]|null
     */
    public function getCancelPenalty()
    {
        return $this->CancelPenalty;
    }
    /**
     * Set CancelPenalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCancelPenaltyType[] $cancelPenalty
     * @return \dgsoft\StructType\DgCancelPenaltiesType
     */
    public function setCancelPenalty(array $cancelPenalty = array())
    {
        foreach ($cancelPenalty as $cancelPenaltiesTypeCancelPenaltyItem) {
            // validation for constraint: itemType
            if (!$cancelPenaltiesTypeCancelPenaltyItem instanceof \dgsoft\StructType\DgCancelPenaltyType) {
                throw new \InvalidArgumentException(sprintf('The CancelPenalty property can only contain items of \dgsoft\StructType\DgCancelPenaltyType, "%s" given', is_object($cancelPenaltiesTypeCancelPenaltyItem) ? get_class($cancelPenaltiesTypeCancelPenaltyItem) : gettype($cancelPenaltiesTypeCancelPenaltyItem)), __LINE__);
            }
        }
        $this->CancelPenalty = $cancelPenalty;
        return $this;
    }
    /**
     * Add item to CancelPenalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCancelPenaltyType $item
     * @return \dgsoft\StructType\DgCancelPenaltiesType
     */
    public function addToCancelPenalty(\dgsoft\StructType\DgCancelPenaltyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCancelPenaltyType) {
            throw new \InvalidArgumentException(sprintf('The CancelPenalty property can only contain items of \dgsoft\StructType\DgCancelPenaltyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CancelPenalty[] = $item;
        return $this;
    }
    /**
     * Get CancelPolicyIndicator value
     * @return bool|null
     */
    public function getCancelPolicyIndicator()
    {
        return $this->CancelPolicyIndicator;
    }
    /**
     * Set CancelPolicyIndicator value
     * @param bool $cancelPolicyIndicator
     * @return \dgsoft\StructType\DgCancelPenaltiesType
     */
    public function setCancelPolicyIndicator($cancelPolicyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelPolicyIndicator) && !is_bool($cancelPolicyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancelPolicyIndicator)), __LINE__);
        }
        $this->CancelPolicyIndicator = $cancelPolicyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCancelPenaltiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
