<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingToBeCancelled StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookingToBeCancelled extends AbstractStructBase
{
    /**
     * The PNRNo
     * @var string
     */
    public $PNRNo;
    /**
     * The ProviderType
     * @var string
     */
    public $ProviderType;
    /**
     * Constructor method for BookingToBeCancelled
     * @uses DgBookingToBeCancelled::setPNRNo()
     * @uses DgBookingToBeCancelled::setProviderType()
     * @param string $pNRNo
     * @param string $providerType
     */
    public function __construct($pNRNo = null, $providerType = null)
    {
        $this
            ->setPNRNo($pNRNo)
            ->setProviderType($providerType);
    }
    /**
     * Get PNRNo value
     * @return string|null
     */
    public function getPNRNo()
    {
        return $this->PNRNo;
    }
    /**
     * Set PNRNo value
     * @param string $pNRNo
     * @return \dgsoft\StructType\DgBookingToBeCancelled
     */
    public function setPNRNo($pNRNo = null)
    {
        // validation for constraint: string
        if (!is_null($pNRNo) && !is_string($pNRNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNRNo)), __LINE__);
        }
        $this->PNRNo = $pNRNo;
        return $this;
    }
    /**
     * Get ProviderType value
     * @return string|null
     */
    public function getProviderType()
    {
        return $this->ProviderType;
    }
    /**
     * Set ProviderType value
     * @param string $providerType
     * @return \dgsoft\StructType\DgBookingToBeCancelled
     */
    public function setProviderType($providerType = null)
    {
        // validation for constraint: string
        if (!is_null($providerType) && !is_string($providerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerType)), __LINE__);
        }
        $this->ProviderType = $providerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookingToBeCancelled
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
