<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingPriceInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookingPriceInfoType extends DgAirItineraryPricingInfoType
{
    /**
     * The PriceRequestInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPriceRequestInformationType
     */
    public $PriceRequestInformation;
    /**
     * The RepriceRequired
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $RepriceRequired;
    /**
     * Constructor method for BookingPriceInfoType
     * @uses DgBookingPriceInfoType::setPriceRequestInformation()
     * @uses DgBookingPriceInfoType::setRepriceRequired()
     * @param \dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation
     * @param bool $repriceRequired
     */
    public function __construct(\dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation = null, $repriceRequired = false)
    {
        $this
            ->setPriceRequestInformation($priceRequestInformation)
            ->setRepriceRequired($repriceRequired);
    }
    /**
     * Get PriceRequestInformation value
     * @return \dgsoft\StructType\DgPriceRequestInformationType|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param \dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation
     * @return \dgsoft\StructType\DgBookingPriceInfoType
     */
    public function setPriceRequestInformation(\dgsoft\StructType\DgPriceRequestInformationType $priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Get RepriceRequired value
     * @return bool|null
     */
    public function getRepriceRequired()
    {
        return $this->RepriceRequired;
    }
    /**
     * Set RepriceRequired value
     * @param bool $repriceRequired
     * @return \dgsoft\StructType\DgBookingPriceInfoType
     */
    public function setRepriceRequired($repriceRequired = false)
    {
        // validation for constraint: boolean
        if (!is_null($repriceRequired) && !is_bool($repriceRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($repriceRequired)), __LINE__);
        }
        $this->RepriceRequired = $repriceRequired;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookingPriceInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
