<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassAvail StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookingClassAvail extends AbstractStructBase
{
    /**
     * The ResBookDesigCode
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ResBookDesigQuantity
     * @var string
     */
    public $ResBookDesigQuantity;
    /**
     * The ResBookDesigStatusCode
     * @var string
     */
    public $ResBookDesigStatusCode;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The AvailablePTC
     * @var string
     */
    public $AvailablePTC;
    /**
     * The ResBookDesigCabinCode
     * @var string
     */
    public $ResBookDesigCabinCode;
    /**
     * The FareBasis
     * @var string
     */
    public $FareBasis;
    /**
     * Constructor method for BookingClassAvail
     * @uses DgBookingClassAvail::setResBookDesigCode()
     * @uses DgBookingClassAvail::setResBookDesigQuantity()
     * @uses DgBookingClassAvail::setResBookDesigStatusCode()
     * @uses DgBookingClassAvail::setRPH()
     * @uses DgBookingClassAvail::setAvailablePTC()
     * @uses DgBookingClassAvail::setResBookDesigCabinCode()
     * @uses DgBookingClassAvail::setFareBasis()
     * @param string $resBookDesigCode
     * @param string $resBookDesigQuantity
     * @param string $resBookDesigStatusCode
     * @param string $rPH
     * @param string $availablePTC
     * @param string $resBookDesigCabinCode
     * @param string $fareBasis
     */
    public function __construct($resBookDesigCode = null, $resBookDesigQuantity = null, $resBookDesigStatusCode = null, $rPH = null, $availablePTC = null, $resBookDesigCabinCode = null, $fareBasis = null)
    {
        $this
            ->setResBookDesigCode($resBookDesigCode)
            ->setResBookDesigQuantity($resBookDesigQuantity)
            ->setResBookDesigStatusCode($resBookDesigStatusCode)
            ->setRPH($rPH)
            ->setAvailablePTC($availablePTC)
            ->setResBookDesigCabinCode($resBookDesigCabinCode)
            ->setFareBasis($fareBasis);
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ResBookDesigQuantity value
     * @return string|null
     */
    public function getResBookDesigQuantity()
    {
        return $this->ResBookDesigQuantity;
    }
    /**
     * Set ResBookDesigQuantity value
     * @param string $resBookDesigQuantity
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setResBookDesigQuantity($resBookDesigQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigQuantity) && !is_string($resBookDesigQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigQuantity)), __LINE__);
        }
        $this->ResBookDesigQuantity = $resBookDesigQuantity;
        return $this;
    }
    /**
     * Get ResBookDesigStatusCode value
     * @return string|null
     */
    public function getResBookDesigStatusCode()
    {
        return $this->ResBookDesigStatusCode;
    }
    /**
     * Set ResBookDesigStatusCode value
     * @param string $resBookDesigStatusCode
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setResBookDesigStatusCode($resBookDesigStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigStatusCode) && !is_string($resBookDesigStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigStatusCode)), __LINE__);
        }
        $this->ResBookDesigStatusCode = $resBookDesigStatusCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AvailablePTC value
     * @return string|null
     */
    public function getAvailablePTC()
    {
        return $this->AvailablePTC;
    }
    /**
     * Set AvailablePTC value
     * @param string $availablePTC
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setAvailablePTC($availablePTC = null)
    {
        // validation for constraint: string
        if (!is_null($availablePTC) && !is_string($availablePTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availablePTC)), __LINE__);
        }
        $this->AvailablePTC = $availablePTC;
        return $this;
    }
    /**
     * Get ResBookDesigCabinCode value
     * @return string|null
     */
    public function getResBookDesigCabinCode()
    {
        return $this->ResBookDesigCabinCode;
    }
    /**
     * Set ResBookDesigCabinCode value
     * @param string $resBookDesigCabinCode
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setResBookDesigCabinCode($resBookDesigCabinCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCabinCode) && !is_string($resBookDesigCabinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCabinCode)), __LINE__);
        }
        $this->ResBookDesigCabinCode = $resBookDesigCabinCode;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return string|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param string $fareBasis
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasis)), __LINE__);
        }
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookingClassAvail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
