<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingChannel StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookingChannel extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $CompanyName;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Primary
     * @var bool
     */
    public $Primary;
    /**
     * Constructor method for BookingChannel
     * @uses DgBookingChannel::setCompanyName()
     * @uses DgBookingChannel::setType()
     * @uses DgBookingChannel::setPrimary()
     * @param \dgsoft\StructType\DgCompanyNameType $companyName
     * @param string $type
     * @param bool $primary
     */
    public function __construct(\dgsoft\StructType\DgCompanyNameType $companyName = null, $type = null, $primary = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setType($type)
            ->setPrimary($primary);
    }
    /**
     * Get CompanyName value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \dgsoft\StructType\DgCompanyNameType $companyName
     * @return \dgsoft\StructType\DgBookingChannel
     */
    public function setCompanyName(\dgsoft\StructType\DgCompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgBookingChannel
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->Primary;
    }
    /**
     * Set Primary value
     * @param bool $primary
     * @return \dgsoft\StructType\DgBookingChannel
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary) && !is_bool($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($primary)), __LINE__);
        }
        $this->Primary = $primary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookingChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
