<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookFlightSegmentType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookFlightSegmentType extends DgFlightSegmentType
{
    /**
     * The MarriageGrp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarriageGrp;
    /**
     * The BookingClassAvails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfBookFlightSegmentTypeBookingClassAvail
     */
    public $BookingClassAvails;
    /**
     * The FlightCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightCharacteristic
     */
    public $FlightCharacteristic;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeTextType[]
     */
    public $Comment;
    /**
     * The StopLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgStopLocation[]
     */
    public $StopLocation;
    /**
     * The ResBookDesigCode
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The NumberInParty
     * @var int
     */
    public $NumberInParty;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The E_TicketEligibility
     * @var string
     */
    public $E_TicketEligibility;
    /**
     * The MealCode
     * @var string
     */
    public $MealCode;
    /**
     * The DepartureDay
     * @var string
     */
    public $DepartureDay;
    /**
     * The StopoverInd
     * @var bool
     */
    public $StopoverInd;
    /**
     * The LineNumber
     * @var int
     */
    public $LineNumber;
    /**
     * The ConnectionType
     * @var string
     */
    public $ConnectionType;
    /**
     * The ParticipationLevelCode
     * @var string
     */
    public $ParticipationLevelCode;
    /**
     * The Distance
     * @var int
     */
    public $Distance;
    /**
     * The DateChangeNbr
     * @var string
     */
    public $DateChangeNbr;
    /**
     * The ValidConnectionInd
     * @var bool
     */
    public $ValidConnectionInd;
    /**
     * Constructor method for BookFlightSegmentType
     * @uses DgBookFlightSegmentType::setMarriageGrp()
     * @uses DgBookFlightSegmentType::setBookingClassAvails()
     * @uses DgBookFlightSegmentType::setFlightCharacteristic()
     * @uses DgBookFlightSegmentType::setComment()
     * @uses DgBookFlightSegmentType::setStopLocation()
     * @uses DgBookFlightSegmentType::setResBookDesigCode()
     * @uses DgBookFlightSegmentType::setNumberInParty()
     * @uses DgBookFlightSegmentType::setStatus()
     * @uses DgBookFlightSegmentType::setE_TicketEligibility()
     * @uses DgBookFlightSegmentType::setMealCode()
     * @uses DgBookFlightSegmentType::setDepartureDay()
     * @uses DgBookFlightSegmentType::setStopoverInd()
     * @uses DgBookFlightSegmentType::setLineNumber()
     * @uses DgBookFlightSegmentType::setConnectionType()
     * @uses DgBookFlightSegmentType::setParticipationLevelCode()
     * @uses DgBookFlightSegmentType::setDistance()
     * @uses DgBookFlightSegmentType::setDateChangeNbr()
     * @uses DgBookFlightSegmentType::setValidConnectionInd()
     * @param string $marriageGrp
     * @param \dgsoft\ArrayType\DgArrayOfBookFlightSegmentTypeBookingClassAvail $bookingClassAvails
     * @param \dgsoft\StructType\DgFlightCharacteristic $flightCharacteristic
     * @param \dgsoft\StructType\DgFreeTextType[] $comment
     * @param \dgsoft\StructType\DgStopLocation[] $stopLocation
     * @param string $resBookDesigCode
     * @param int $numberInParty
     * @param string $status
     * @param string $e_TicketEligibility
     * @param string $mealCode
     * @param string $departureDay
     * @param bool $stopoverInd
     * @param int $lineNumber
     * @param string $connectionType
     * @param string $participationLevelCode
     * @param int $distance
     * @param string $dateChangeNbr
     * @param bool $validConnectionInd
     */
    public function __construct($marriageGrp = null, \dgsoft\ArrayType\DgArrayOfBookFlightSegmentTypeBookingClassAvail $bookingClassAvails = null, \dgsoft\StructType\DgFlightCharacteristic $flightCharacteristic = null, array $comment = array(), array $stopLocation = array(), $resBookDesigCode = null, $numberInParty = null, $status = null, $e_TicketEligibility = null, $mealCode = null, $departureDay = null, $stopoverInd = null, $lineNumber = null, $connectionType = null, $participationLevelCode = null, $distance = null, $dateChangeNbr = null, $validConnectionInd = null)
    {
        $this
            ->setMarriageGrp($marriageGrp)
            ->setBookingClassAvails($bookingClassAvails)
            ->setFlightCharacteristic($flightCharacteristic)
            ->setComment($comment)
            ->setStopLocation($stopLocation)
            ->setResBookDesigCode($resBookDesigCode)
            ->setNumberInParty($numberInParty)
            ->setStatus($status)
            ->setE_TicketEligibility($e_TicketEligibility)
            ->setMealCode($mealCode)
            ->setDepartureDay($departureDay)
            ->setStopoverInd($stopoverInd)
            ->setLineNumber($lineNumber)
            ->setConnectionType($connectionType)
            ->setParticipationLevelCode($participationLevelCode)
            ->setDistance($distance)
            ->setDateChangeNbr($dateChangeNbr)
            ->setValidConnectionInd($validConnectionInd);
    }
    /**
     * Get MarriageGrp value
     * @return string|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param string $marriageGrp
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        // validation for constraint: string
        if (!is_null($marriageGrp) && !is_string($marriageGrp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marriageGrp)), __LINE__);
        }
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get BookingClassAvails value
     * @return \dgsoft\ArrayType\DgArrayOfBookFlightSegmentTypeBookingClassAvail|null
     */
    public function getBookingClassAvails()
    {
        return $this->BookingClassAvails;
    }
    /**
     * Set BookingClassAvails value
     * @param \dgsoft\ArrayType\DgArrayOfBookFlightSegmentTypeBookingClassAvail $bookingClassAvails
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setBookingClassAvails(\dgsoft\ArrayType\DgArrayOfBookFlightSegmentTypeBookingClassAvail $bookingClassAvails = null)
    {
        $this->BookingClassAvails = $bookingClassAvails;
        return $this;
    }
    /**
     * Get FlightCharacteristic value
     * @return \dgsoft\StructType\DgFlightCharacteristic|null
     */
    public function getFlightCharacteristic()
    {
        return $this->FlightCharacteristic;
    }
    /**
     * Set FlightCharacteristic value
     * @param \dgsoft\StructType\DgFlightCharacteristic $flightCharacteristic
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setFlightCharacteristic(\dgsoft\StructType\DgFlightCharacteristic $flightCharacteristic = null)
    {
        $this->FlightCharacteristic = $flightCharacteristic;
        return $this;
    }
    /**
     * Get Comment value
     * @return \dgsoft\StructType\DgFreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType[] $comment
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $bookFlightSegmentTypeCommentItem) {
            // validation for constraint: itemType
            if (!$bookFlightSegmentTypeCommentItem instanceof \dgsoft\StructType\DgFreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($bookFlightSegmentTypeCommentItem) ? get_class($bookFlightSegmentTypeCommentItem) : gettype($bookFlightSegmentTypeCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType $item
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function addToComment(\dgsoft\StructType\DgFreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get StopLocation value
     * @return \dgsoft\StructType\DgStopLocation[]|null
     */
    public function getStopLocation()
    {
        return $this->StopLocation;
    }
    /**
     * Set StopLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgStopLocation[] $stopLocation
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setStopLocation(array $stopLocation = array())
    {
        foreach ($stopLocation as $bookFlightSegmentTypeStopLocationItem) {
            // validation for constraint: itemType
            if (!$bookFlightSegmentTypeStopLocationItem instanceof \dgsoft\StructType\DgStopLocation) {
                throw new \InvalidArgumentException(sprintf('The StopLocation property can only contain items of \dgsoft\StructType\DgStopLocation, "%s" given', is_object($bookFlightSegmentTypeStopLocationItem) ? get_class($bookFlightSegmentTypeStopLocationItem) : gettype($bookFlightSegmentTypeStopLocationItem)), __LINE__);
            }
        }
        $this->StopLocation = $stopLocation;
        return $this;
    }
    /**
     * Add item to StopLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgStopLocation $item
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function addToStopLocation(\dgsoft\StructType\DgStopLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgStopLocation) {
            throw new \InvalidArgumentException(sprintf('The StopLocation property can only contain items of \dgsoft\StructType\DgStopLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopLocation[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !is_numeric($numberInParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get E_TicketEligibility value
     * @return string|null
     */
    public function getE_TicketEligibility()
    {
        return $this->E_TicketEligibility;
    }
    /**
     * Set E_TicketEligibility value
     * @param string $e_TicketEligibility
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setE_TicketEligibility($e_TicketEligibility = null)
    {
        // validation for constraint: string
        if (!is_null($e_TicketEligibility) && !is_string($e_TicketEligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e_TicketEligibility)), __LINE__);
        }
        $this->E_TicketEligibility = $e_TicketEligibility;
        return $this;
    }
    /**
     * Get MealCode value
     * @return string|null
     */
    public function getMealCode()
    {
        return $this->MealCode;
    }
    /**
     * Set MealCode value
     * @param string $mealCode
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setMealCode($mealCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealCode) && !is_string($mealCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealCode)), __LINE__);
        }
        $this->MealCode = $mealCode;
        return $this;
    }
    /**
     * Get DepartureDay value
     * @return string|null
     */
    public function getDepartureDay()
    {
        return $this->DepartureDay;
    }
    /**
     * Set DepartureDay value
     * @uses \dgsoft\EnumType\DgDayOfWeekType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureDay
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setDepartureDay($departureDay = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDayOfWeekType::valueIsValid($departureDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureDay, implode(', ', \dgsoft\EnumType\DgDayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DepartureDay = $departureDay;
        return $this;
    }
    /**
     * Get StopoverInd value
     * @return bool|null
     */
    public function getStopoverInd()
    {
        return $this->StopoverInd;
    }
    /**
     * Set StopoverInd value
     * @param bool $stopoverInd
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setStopoverInd($stopoverInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($stopoverInd) && !is_bool($stopoverInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($stopoverInd)), __LINE__);
        }
        $this->StopoverInd = $stopoverInd;
        return $this;
    }
    /**
     * Get LineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !is_numeric($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get ConnectionType value
     * @return string|null
     */
    public function getConnectionType()
    {
        return $this->ConnectionType;
    }
    /**
     * Set ConnectionType value
     * @param string $connectionType
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setConnectionType($connectionType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionType) && !is_string($connectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionType)), __LINE__);
        }
        $this->ConnectionType = $connectionType;
        return $this;
    }
    /**
     * Get ParticipationLevelCode value
     * @return string|null
     */
    public function getParticipationLevelCode()
    {
        return $this->ParticipationLevelCode;
    }
    /**
     * Set ParticipationLevelCode value
     * @param string $participationLevelCode
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setParticipationLevelCode($participationLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($participationLevelCode) && !is_string($participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participationLevelCode)), __LINE__);
        }
        $this->ParticipationLevelCode = $participationLevelCode;
        return $this;
    }
    /**
     * Get Distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DateChangeNbr value
     * @return string|null
     */
    public function getDateChangeNbr()
    {
        return $this->DateChangeNbr;
    }
    /**
     * Set DateChangeNbr value
     * @param string $dateChangeNbr
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setDateChangeNbr($dateChangeNbr = null)
    {
        // validation for constraint: string
        if (!is_null($dateChangeNbr) && !is_string($dateChangeNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateChangeNbr)), __LINE__);
        }
        $this->DateChangeNbr = $dateChangeNbr;
        return $this;
    }
    /**
     * Get ValidConnectionInd value
     * @return bool|null
     */
    public function getValidConnectionInd()
    {
        return $this->ValidConnectionInd;
    }
    /**
     * Set ValidConnectionInd value
     * @param bool $validConnectionInd
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public function setValidConnectionInd($validConnectionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($validConnectionInd) && !is_bool($validConnectionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($validConnectionInd)), __LINE__);
        }
        $this->ValidConnectionInd = $validConnectionInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
