<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseFare StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBaseFare extends AbstractStructBase
{
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Rate
     * @var float
     */
    public $Rate;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * Constructor method for BaseFare
     * @uses DgBaseFare::setCurrency()
     * @uses DgBaseFare::setAmount()
     * @uses DgBaseFare::setRate()
     * @uses DgBaseFare::setDate()
     * @param string $currency
     * @param float $amount
     * @param float $rate
     * @param string $date
     */
    public function __construct($currency = null, $amount = null, $rate = null, $date = null)
    {
        $this
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setRate($rate)
            ->setDate($date);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgBaseFare
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgBaseFare
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \dgsoft\StructType\DgBaseFare
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \dgsoft\StructType\DgBaseFare
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBaseFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
