<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageInfoRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBaggageInfoRQ extends DgServiceFeeInfoRQ
{
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerInfo[]
     */
    public $Passenger;
    /**
     * Constructor method for BaggageInfoRQ
     * @uses DgBaggageInfoRQ::setPassenger()
     * @param \dgsoft\StructType\DgPassengerInfo[] $passenger
     */
    public function __construct(array $passenger = array())
    {
        $this
            ->setPassenger($passenger);
    }
    /**
     * Get Passenger value
     * @return \dgsoft\StructType\DgPassengerInfo[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerInfo[] $passenger
     * @return \dgsoft\StructType\DgBaggageInfoRQ
     */
    public function setPassenger(array $passenger = array())
    {
        foreach ($passenger as $baggageInfoRQPassengerItem) {
            // validation for constraint: itemType
            if (!$baggageInfoRQPassengerItem instanceof \dgsoft\StructType\DgPassengerInfo) {
                throw new \InvalidArgumentException(sprintf('The Passenger property can only contain items of \dgsoft\StructType\DgPassengerInfo, "%s" given', is_object($baggageInfoRQPassengerItem) ? get_class($baggageInfoRQPassengerItem) : gettype($baggageInfoRQPassengerItem)), __LINE__);
            }
        }
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerInfo $item
     * @return \dgsoft\StructType\DgBaggageInfoRQ
     */
    public function addToPassenger(\dgsoft\StructType\DgPassengerInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPassengerInfo) {
            throw new \InvalidArgumentException(sprintf('The Passenger property can only contain items of \dgsoft\StructType\DgPassengerInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBaggageInfoRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
