<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Baggage StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBaggage extends AbstractStructBase
{
    /**
     * The Index
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Index;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Unit
     * @var string
     */
    public $Unit;
    /**
     * Constructor method for Baggage
     * @uses DgBaggage::setIndex()
     * @uses DgBaggage::setType()
     * @uses DgBaggage::setQuantity()
     * @uses DgBaggage::setUnit()
     * @param int $index
     * @param string $type
     * @param string $quantity
     * @param string $unit
     */
    public function __construct($index = null, $type = null, $quantity = null, $unit = null)
    {
        $this
            ->setIndex($index)
            ->setType($type)
            ->setQuantity($quantity)
            ->setUnit($unit);
    }
    /**
     * Get Index value
     * @return int
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \dgsoft\StructType\DgBaggage
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !is_numeric($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgBaggage
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \dgsoft\StructType\DgBaggage
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \dgsoft\StructType\DgBaggage
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBaggage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
