<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizedViewer StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAuthorizedViewer extends AbstractStructBase
{
    /**
     * The ViewerCode
     * @var string
     */
    public $ViewerCode;
    /**
     * The ViewerCarrierCode
     * @var string
     */
    public $ViewerCarrierCode;
    /**
     * Constructor method for AuthorizedViewer
     * @uses DgAuthorizedViewer::setViewerCode()
     * @uses DgAuthorizedViewer::setViewerCarrierCode()
     * @param string $viewerCode
     * @param string $viewerCarrierCode
     */
    public function __construct($viewerCode = null, $viewerCarrierCode = null)
    {
        $this
            ->setViewerCode($viewerCode)
            ->setViewerCarrierCode($viewerCarrierCode);
    }
    /**
     * Get ViewerCode value
     * @return string|null
     */
    public function getViewerCode()
    {
        return $this->ViewerCode;
    }
    /**
     * Set ViewerCode value
     * @param string $viewerCode
     * @return \dgsoft\StructType\DgAuthorizedViewer
     */
    public function setViewerCode($viewerCode = null)
    {
        // validation for constraint: string
        if (!is_null($viewerCode) && !is_string($viewerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($viewerCode)), __LINE__);
        }
        $this->ViewerCode = $viewerCode;
        return $this;
    }
    /**
     * Get ViewerCarrierCode value
     * @return string|null
     */
    public function getViewerCarrierCode()
    {
        return $this->ViewerCarrierCode;
    }
    /**
     * Set ViewerCarrierCode value
     * @param string $viewerCarrierCode
     * @return \dgsoft\StructType\DgAuthorizedViewer
     */
    public function setViewerCarrierCode($viewerCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($viewerCarrierCode) && !is_string($viewerCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($viewerCarrierCode)), __LINE__);
        }
        $this->ViewerCarrierCode = $viewerCarrierCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAuthorizedViewer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
