<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Areas StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAreas extends AbstractStructBase
{
    /**
     * The AreaDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $AreaDescription;
    /**
     * The AreaID
     * @var string
     */
    public $AreaID;
    /**
     * The CityCode
     * @var string
     */
    public $CityCode;
    /**
     * The StateProvCode
     * @var string
     */
    public $StateProvCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for Areas
     * @uses DgAreas::setAreaDescription()
     * @uses DgAreas::setAreaID()
     * @uses DgAreas::setCityCode()
     * @uses DgAreas::setStateProvCode()
     * @uses DgAreas::setCountryCode()
     * @param \dgsoft\StructType\DgParagraphType $areaDescription
     * @param string $areaID
     * @param string $cityCode
     * @param string $stateProvCode
     * @param string $countryCode
     */
    public function __construct(\dgsoft\StructType\DgParagraphType $areaDescription = null, $areaID = null, $cityCode = null, $stateProvCode = null, $countryCode = null)
    {
        $this
            ->setAreaDescription($areaDescription)
            ->setAreaID($areaID)
            ->setCityCode($cityCode)
            ->setStateProvCode($stateProvCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get AreaDescription value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getAreaDescription()
    {
        return $this->AreaDescription;
    }
    /**
     * Set AreaDescription value
     * @param \dgsoft\StructType\DgParagraphType $areaDescription
     * @return \dgsoft\StructType\DgAreas
     */
    public function setAreaDescription(\dgsoft\StructType\DgParagraphType $areaDescription = null)
    {
        $this->AreaDescription = $areaDescription;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \dgsoft\StructType\DgAreas
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \dgsoft\StructType\DgAreas
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get StateProvCode value
     * @return string|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param string $stateProvCode
     * @return \dgsoft\StructType\DgAreas
     */
    public function setStateProvCode($stateProvCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvCode) && !is_string($stateProvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateProvCode)), __LINE__);
        }
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \dgsoft\StructType\DgAreas
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAreas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
