<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryTicketFOPType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryTicketFOPType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The CCNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CCNumber;
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentDetail;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmount;
    /**
     * The PaymentCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCurrency;
    /**
     * The PaymentAmountDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmountDetail;
    /**
     * Constructor method for AncillaryTicketFOPType
     * @uses DgAncillaryTicketFOPType::setPaymentTypeCode()
     * @uses DgAncillaryTicketFOPType::setPaymentType()
     * @uses DgAncillaryTicketFOPType::setVendorCode()
     * @uses DgAncillaryTicketFOPType::setCCNumber()
     * @uses DgAncillaryTicketFOPType::setPaymentDetail()
     * @uses DgAncillaryTicketFOPType::setPaymentAmount()
     * @uses DgAncillaryTicketFOPType::setPaymentCurrency()
     * @uses DgAncillaryTicketFOPType::setPaymentAmountDetail()
     * @param string $paymentTypeCode
     * @param string $paymentType
     * @param string $vendorCode
     * @param string $cCNumber
     * @param string $paymentDetail
     * @param string $paymentAmount
     * @param string $paymentCurrency
     * @param string $paymentAmountDetail
     */
    public function __construct($paymentTypeCode = null, $paymentType = null, $vendorCode = null, $cCNumber = null, $paymentDetail = null, $paymentAmount = null, $paymentCurrency = null, $paymentAmountDetail = null)
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setPaymentType($paymentType)
            ->setVendorCode($vendorCode)
            ->setCCNumber($cCNumber)
            ->setPaymentDetail($paymentDetail)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentCurrency($paymentCurrency)
            ->setPaymentAmountDetail($paymentAmountDetail);
    }
    /**
     * Get PaymentTypeCode value
     * @return string|null
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get CCNumber value
     * @return string|null
     */
    public function getCCNumber()
    {
        return $this->CCNumber;
    }
    /**
     * Set CCNumber value
     * @param string $cCNumber
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setCCNumber($cCNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cCNumber) && !is_string($cCNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCNumber)), __LINE__);
        }
        $this->CCNumber = $cCNumber;
        return $this;
    }
    /**
     * Get PaymentDetail value
     * @return string|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @param string $paymentDetail
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setPaymentDetail($paymentDetail = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetail) && !is_string($paymentDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDetail)), __LINE__);
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return string|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param string $paymentAmount
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmount) && !is_string($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get PaymentCurrency value
     * @return string|null
     */
    public function getPaymentCurrency()
    {
        return $this->PaymentCurrency;
    }
    /**
     * Set PaymentCurrency value
     * @param string $paymentCurrency
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setPaymentCurrency($paymentCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCurrency) && !is_string($paymentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentCurrency)), __LINE__);
        }
        $this->PaymentCurrency = $paymentCurrency;
        return $this;
    }
    /**
     * Get PaymentAmountDetail value
     * @return string|null
     */
    public function getPaymentAmountDetail()
    {
        return $this->PaymentAmountDetail;
    }
    /**
     * Set PaymentAmountDetail value
     * @param string $paymentAmountDetail
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public function setPaymentAmountDetail($paymentAmountDetail = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmountDetail) && !is_string($paymentAmountDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmountDetail)), __LINE__);
        }
        $this->PaymentAmountDetail = $paymentAmountDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
