<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryProductTypeBase StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryProductTypeBase extends AbstractStructBase
{
    /**
     * The SegmentReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SegmentReference;
    /**
     * The SSRCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSRCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for AncillaryProductTypeBase
     * @uses DgAncillaryProductTypeBase::setSegmentReference()
     * @uses DgAncillaryProductTypeBase::setSSRCode()
     * @uses DgAncillaryProductTypeBase::setDescription()
     * @uses DgAncillaryProductTypeBase::setStatus()
     * @param int $segmentReference
     * @param string $sSRCode
     * @param string $description
     * @param string $status
     */
    public function __construct($segmentReference = null, $sSRCode = null, $description = null, $status = null)
    {
        $this
            ->setSegmentReference($segmentReference)
            ->setSSRCode($sSRCode)
            ->setDescription($description)
            ->setStatus($status);
    }
    /**
     * Get SegmentReference value
     * @return int
     */
    public function getSegmentReference()
    {
        return $this->SegmentReference;
    }
    /**
     * Set SegmentReference value
     * @param int $segmentReference
     * @return \dgsoft\StructType\DgAncillaryProductTypeBase
     */
    public function setSegmentReference($segmentReference = null)
    {
        // validation for constraint: int
        if (!is_null($segmentReference) && !is_numeric($segmentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($segmentReference)), __LINE__);
        }
        $this->SegmentReference = $segmentReference;
        return $this;
    }
    /**
     * Get SSRCode value
     * @return string|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \dgsoft\StructType\DgAncillaryProductTypeBase
     */
    public function setSSRCode($sSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSRCode) && !is_string($sSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSRCode)), __LINE__);
        }
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \dgsoft\StructType\DgAncillaryProductTypeBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgAncillaryProductTypeBase
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryProductTypeBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
