<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryChangeParameter StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryChangeParameter extends AbstractStructBase
{
    /**
     * The SegmentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SegmentRef;
    /**
     * The NewAncillaryFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NewAncillaryFee;
    /**
     * The OldAncillaryFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OldAncillaryFee;
    /**
     * The AncillaryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AncillaryType;
    /**
     * Constructor method for AncillaryChangeParameter
     * @uses DgAncillaryChangeParameter::setSegmentRef()
     * @uses DgAncillaryChangeParameter::setNewAncillaryFee()
     * @uses DgAncillaryChangeParameter::setOldAncillaryFee()
     * @uses DgAncillaryChangeParameter::setAncillaryType()
     * @param int $segmentRef
     * @param float $newAncillaryFee
     * @param float $oldAncillaryFee
     * @param string $ancillaryType
     */
    public function __construct($segmentRef = null, $newAncillaryFee = null, $oldAncillaryFee = null, $ancillaryType = null)
    {
        $this
            ->setSegmentRef($segmentRef)
            ->setNewAncillaryFee($newAncillaryFee)
            ->setOldAncillaryFee($oldAncillaryFee)
            ->setAncillaryType($ancillaryType);
    }
    /**
     * Get SegmentRef value
     * @return int
     */
    public function getSegmentRef()
    {
        return $this->SegmentRef;
    }
    /**
     * Set SegmentRef value
     * @param int $segmentRef
     * @return \dgsoft\StructType\DgAncillaryChangeParameter
     */
    public function setSegmentRef($segmentRef = null)
    {
        // validation for constraint: int
        if (!is_null($segmentRef) && !is_numeric($segmentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($segmentRef)), __LINE__);
        }
        $this->SegmentRef = $segmentRef;
        return $this;
    }
    /**
     * Get NewAncillaryFee value
     * @return float
     */
    public function getNewAncillaryFee()
    {
        return $this->NewAncillaryFee;
    }
    /**
     * Set NewAncillaryFee value
     * @param float $newAncillaryFee
     * @return \dgsoft\StructType\DgAncillaryChangeParameter
     */
    public function setNewAncillaryFee($newAncillaryFee = null)
    {
        $this->NewAncillaryFee = $newAncillaryFee;
        return $this;
    }
    /**
     * Get OldAncillaryFee value
     * @return float
     */
    public function getOldAncillaryFee()
    {
        return $this->OldAncillaryFee;
    }
    /**
     * Set OldAncillaryFee value
     * @param float $oldAncillaryFee
     * @return \dgsoft\StructType\DgAncillaryChangeParameter
     */
    public function setOldAncillaryFee($oldAncillaryFee = null)
    {
        $this->OldAncillaryFee = $oldAncillaryFee;
        return $this;
    }
    /**
     * Get AncillaryType value
     * @return string|null
     */
    public function getAncillaryType()
    {
        return $this->AncillaryType;
    }
    /**
     * Set AncillaryType value
     * @param string $ancillaryType
     * @return \dgsoft\StructType\DgAncillaryChangeParameter
     */
    public function setAncillaryType($ancillaryType = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryType) && !is_string($ancillaryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ancillaryType)), __LINE__);
        }
        $this->AncillaryType = $ancillaryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryChangeParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
