<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllianceMember StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAllianceMember extends DgCompanyNameType
{
    /**
     * The _
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $_;
    /**
     * The MemberCode
     * @var string
     */
    public $MemberCode;
    /**
     * Constructor method for AllianceMember
     * @uses DgAllianceMember::set_()
     * @uses DgAllianceMember::setMemberCode()
     * @param \dgsoft\StructType\DgCompanyNameType $_
     * @param string $memberCode
     */
    public function __construct(\dgsoft\StructType\DgCompanyNameType $_ = null, $memberCode = null)
    {
        $this
            ->set_($_)
            ->setMemberCode($memberCode);
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgCompanyNameType $_
     * @return \dgsoft\StructType\DgAllianceMember
     */
    public function set_(\dgsoft\StructType\DgCompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get MemberCode value
     * @return string|null
     */
    public function getMemberCode()
    {
        return $this->MemberCode;
    }
    /**
     * Set MemberCode value
     * @param string $memberCode
     * @return \dgsoft\StructType\DgAllianceMember
     */
    public function setMemberCode($memberCode = null)
    {
        // validation for constraint: string
        if (!is_null($memberCode) && !is_string($memberCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memberCode)), __LINE__);
        }
        $this->MemberCode = $memberCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAllianceMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
