<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineDiversityType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirlineDiversityType extends AbstractStructBase
{
    /**
     * The DiversityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DiversityType;
    /**
     * Constructor method for AirlineDiversityType
     * @uses DgAirlineDiversityType::setDiversityType()
     * @param string[] $diversityType
     */
    public function __construct(array $diversityType = array())
    {
        $this
            ->setDiversityType($diversityType);
    }
    /**
     * Get DiversityType value
     * @return string[]|null
     */
    public function getDiversityType()
    {
        return $this->DiversityType;
    }
    /**
     * Set DiversityType value
     * @uses \dgsoft\EnumType\DgAirlineDiversityEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgAirlineDiversityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $diversityType
     * @return \dgsoft\StructType\DgAirlineDiversityType
     */
    public function setDiversityType(array $diversityType = array())
    {
        $invalidValues = array();
        foreach ($diversityType as $airlineDiversityTypeDiversityTypeItem) {
            if (!\dgsoft\EnumType\DgAirlineDiversityEnum::valueIsValid($airlineDiversityTypeDiversityTypeItem)) {
                $invalidValues[] = var_export($airlineDiversityTypeDiversityTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgAirlineDiversityEnum::getValidValues())), __LINE__);
        }
        $this->DiversityType = $diversityType;
        return $this;
    }
    /**
     * Add item to DiversityType value
     * @uses \dgsoft\EnumType\DgAirlineDiversityEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgAirlineDiversityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgAirlineDiversityType
     */
    public function addToDiversityType($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAirlineDiversityEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgAirlineDiversityEnum::getValidValues())), __LINE__);
        }
        $this->DiversityType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirlineDiversityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
