<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTraveler StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirTraveler extends DgAirTravelerType
{
    /**
     * The OSIMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OSIMessage;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgComment[]
     */
    public $Comment;
    /**
     * The eTicketDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgETicketInfo
     */
    public $eTicketDocument;
    /**
     * The eTicketDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfETicketInfo
     */
    public $eTicketDocuments;
    /**
     * The ETicketURLs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgETicketURLs[]
     */
    public $ETicketURLs;
    /**
     * The AncillaryProducts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryProductsType
     */
    public $AncillaryProducts;
    /**
     * The FreeBaggageAllowance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeBaggageAllowancesTypes
     */
    public $FreeBaggageAllowance;
    /**
     * The StandardAncillaryProducts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgStandardAncillaryProductsType
     */
    public $StandardAncillaryProducts;
    /**
     * The eTicketNumber
     * @var string
     */
    public $eTicketNumber;
    /**
     * Constructor method for AirTraveler
     * @uses DgAirTraveler::setOSIMessage()
     * @uses DgAirTraveler::setComment()
     * @uses DgAirTraveler::setETicketDocument()
     * @uses DgAirTraveler::setETicketDocuments()
     * @uses DgAirTraveler::setETicketURLs()
     * @uses DgAirTraveler::setAncillaryProducts()
     * @uses DgAirTraveler::setFreeBaggageAllowance()
     * @uses DgAirTraveler::setStandardAncillaryProducts()
     * @uses DgAirTraveler::setETicketNumber()
     * @param string[] $oSIMessage
     * @param \dgsoft\StructType\DgComment[] $comment
     * @param \dgsoft\StructType\DgETicketInfo $eTicketDocument
     * @param \dgsoft\ArrayType\DgArrayOfETicketInfo $eTicketDocuments
     * @param \dgsoft\StructType\DgETicketURLs[] $eTicketURLs
     * @param \dgsoft\StructType\DgAncillaryProductsType $ancillaryProducts
     * @param \dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance
     * @param \dgsoft\StructType\DgStandardAncillaryProductsType $standardAncillaryProducts
     * @param string $eTicketNumber
     */
    public function __construct(array $oSIMessage = array(), array $comment = array(), \dgsoft\StructType\DgETicketInfo $eTicketDocument = null, \dgsoft\ArrayType\DgArrayOfETicketInfo $eTicketDocuments = null, array $eTicketURLs = array(), \dgsoft\StructType\DgAncillaryProductsType $ancillaryProducts = null, \dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance = null, \dgsoft\StructType\DgStandardAncillaryProductsType $standardAncillaryProducts = null, $eTicketNumber = null)
    {
        $this
            ->setOSIMessage($oSIMessage)
            ->setComment($comment)
            ->setETicketDocument($eTicketDocument)
            ->setETicketDocuments($eTicketDocuments)
            ->setETicketURLs($eTicketURLs)
            ->setAncillaryProducts($ancillaryProducts)
            ->setFreeBaggageAllowance($freeBaggageAllowance)
            ->setStandardAncillaryProducts($standardAncillaryProducts)
            ->setETicketNumber($eTicketNumber);
    }
    /**
     * Get OSIMessage value
     * @return string[]|null
     */
    public function getOSIMessage()
    {
        return $this->OSIMessage;
    }
    /**
     * Set OSIMessage value
     * @throws \InvalidArgumentException
     * @param string[] $oSIMessage
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setOSIMessage(array $oSIMessage = array())
    {
        foreach ($oSIMessage as $airTravelerOSIMessageItem) {
            // validation for constraint: itemType
            if (!is_string($airTravelerOSIMessageItem)) {
                throw new \InvalidArgumentException(sprintf('The OSIMessage property can only contain items of string, "%s" given', is_object($airTravelerOSIMessageItem) ? get_class($airTravelerOSIMessageItem) : gettype($airTravelerOSIMessageItem)), __LINE__);
            }
        }
        $this->OSIMessage = $oSIMessage;
        return $this;
    }
    /**
     * Add item to OSIMessage value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function addToOSIMessage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OSIMessage property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OSIMessage[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \dgsoft\StructType\DgComment[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgComment[] $comment
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $airTravelerCommentItem) {
            // validation for constraint: itemType
            if (!$airTravelerCommentItem instanceof \dgsoft\StructType\DgComment) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgComment, "%s" given', is_object($airTravelerCommentItem) ? get_class($airTravelerCommentItem) : gettype($airTravelerCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgComment $item
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function addToComment(\dgsoft\StructType\DgComment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgComment) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgComment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get eTicketDocument value
     * @return \dgsoft\StructType\DgETicketInfo|null
     */
    public function getETicketDocument()
    {
        return $this->eTicketDocument;
    }
    /**
     * Set eTicketDocument value
     * @param \dgsoft\StructType\DgETicketInfo $eTicketDocument
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setETicketDocument(\dgsoft\StructType\DgETicketInfo $eTicketDocument = null)
    {
        $this->eTicketDocument = $eTicketDocument;
        return $this;
    }
    /**
     * Get eTicketDocuments value
     * @return \dgsoft\ArrayType\DgArrayOfETicketInfo|null
     */
    public function getETicketDocuments()
    {
        return $this->eTicketDocuments;
    }
    /**
     * Set eTicketDocuments value
     * @param \dgsoft\ArrayType\DgArrayOfETicketInfo $eTicketDocuments
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setETicketDocuments(\dgsoft\ArrayType\DgArrayOfETicketInfo $eTicketDocuments = null)
    {
        $this->eTicketDocuments = $eTicketDocuments;
        return $this;
    }
    /**
     * Get ETicketURLs value
     * @return \dgsoft\StructType\DgETicketURLs[]|null
     */
    public function getETicketURLs()
    {
        return $this->ETicketURLs;
    }
    /**
     * Set ETicketURLs value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgETicketURLs[] $eTicketURLs
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setETicketURLs(array $eTicketURLs = array())
    {
        foreach ($eTicketURLs as $airTravelerETicketURLsItem) {
            // validation for constraint: itemType
            if (!$airTravelerETicketURLsItem instanceof \dgsoft\StructType\DgETicketURLs) {
                throw new \InvalidArgumentException(sprintf('The ETicketURLs property can only contain items of \dgsoft\StructType\DgETicketURLs, "%s" given', is_object($airTravelerETicketURLsItem) ? get_class($airTravelerETicketURLsItem) : gettype($airTravelerETicketURLsItem)), __LINE__);
            }
        }
        $this->ETicketURLs = $eTicketURLs;
        return $this;
    }
    /**
     * Add item to ETicketURLs value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgETicketURLs $item
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function addToETicketURLs(\dgsoft\StructType\DgETicketURLs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgETicketURLs) {
            throw new \InvalidArgumentException(sprintf('The ETicketURLs property can only contain items of \dgsoft\StructType\DgETicketURLs, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ETicketURLs[] = $item;
        return $this;
    }
    /**
     * Get AncillaryProducts value
     * @return \dgsoft\StructType\DgAncillaryProductsType|null
     */
    public function getAncillaryProducts()
    {
        return $this->AncillaryProducts;
    }
    /**
     * Set AncillaryProducts value
     * @param \dgsoft\StructType\DgAncillaryProductsType $ancillaryProducts
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setAncillaryProducts(\dgsoft\StructType\DgAncillaryProductsType $ancillaryProducts = null)
    {
        $this->AncillaryProducts = $ancillaryProducts;
        return $this;
    }
    /**
     * Get FreeBaggageAllowance value
     * @return \dgsoft\StructType\DgFreeBaggageAllowancesTypes|null
     */
    public function getFreeBaggageAllowance()
    {
        return $this->FreeBaggageAllowance;
    }
    /**
     * Set FreeBaggageAllowance value
     * @param \dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setFreeBaggageAllowance(\dgsoft\StructType\DgFreeBaggageAllowancesTypes $freeBaggageAllowance = null)
    {
        $this->FreeBaggageAllowance = $freeBaggageAllowance;
        return $this;
    }
    /**
     * Get StandardAncillaryProducts value
     * @return \dgsoft\StructType\DgStandardAncillaryProductsType|null
     */
    public function getStandardAncillaryProducts()
    {
        return $this->StandardAncillaryProducts;
    }
    /**
     * Set StandardAncillaryProducts value
     * @param \dgsoft\StructType\DgStandardAncillaryProductsType $standardAncillaryProducts
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setStandardAncillaryProducts(\dgsoft\StructType\DgStandardAncillaryProductsType $standardAncillaryProducts = null)
    {
        $this->StandardAncillaryProducts = $standardAncillaryProducts;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param string $eTicketNumber
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eTicketNumber) && !is_string($eTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eTicketNumber)), __LINE__);
        }
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirTraveler
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
