<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSearchPrefsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirSearchPrefsType extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVendorPref[]
     */
    public $VendorPref;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The FareRestrictPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCabinPref[]
     */
    public $CabinPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketDistribPref[]
     */
    public $TicketDistribPref;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The OnTimeRate
     * @var float
     */
    public $OnTimeRate;
    /**
     * The ETicketDesired
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $ETicketDesired;
    /**
     * The MaxStopsQuantity
     * @var int
     */
    public $MaxStopsQuantity;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for AirSearchPrefsType
     * @uses DgAirSearchPrefsType::setVendorPref()
     * @uses DgAirSearchPrefsType::setFlightTypePref()
     * @uses DgAirSearchPrefsType::setFareRestrictPref()
     * @uses DgAirSearchPrefsType::setEquipPref()
     * @uses DgAirSearchPrefsType::setCabinPref()
     * @uses DgAirSearchPrefsType::setTicketDistribPref()
     * @uses DgAirSearchPrefsType::setSmokingAllowed()
     * @uses DgAirSearchPrefsType::setOnTimeRate()
     * @uses DgAirSearchPrefsType::setETicketDesired()
     * @uses DgAirSearchPrefsType::setMaxStopsQuantity()
     * @uses DgAirSearchPrefsType::setStart()
     * @uses DgAirSearchPrefsType::setDuration()
     * @uses DgAirSearchPrefsType::setEnd()
     * @param \dgsoft\StructType\DgVendorPref[] $vendorPref
     * @param \dgsoft\StructType\DgFlightTypePref[] $flightTypePref
     * @param \dgsoft\StructType\DgFareRestrictPref[] $fareRestrictPref
     * @param \dgsoft\StructType\DgEquipmentTypePref[] $equipPref
     * @param \dgsoft\StructType\DgCabinPref[] $cabinPref
     * @param \dgsoft\StructType\DgTicketDistribPref[] $ticketDistribPref
     * @param bool $smokingAllowed
     * @param float $onTimeRate
     * @param bool $eTicketDesired
     * @param int $maxStopsQuantity
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(array $vendorPref = array(), array $flightTypePref = array(), array $fareRestrictPref = array(), array $equipPref = array(), array $cabinPref = array(), array $ticketDistribPref = array(), $smokingAllowed = false, $onTimeRate = null, $eTicketDesired = false, $maxStopsQuantity = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setFlightTypePref($flightTypePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setSmokingAllowed($smokingAllowed)
            ->setOnTimeRate($onTimeRate)
            ->setETicketDesired($eTicketDesired)
            ->setMaxStopsQuantity($maxStopsQuantity)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgVendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVendorPref[] $vendorPref
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $airSearchPrefsTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeVendorPrefItem instanceof \dgsoft\StructType\DgVendorPref) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgVendorPref, "%s" given', is_object($airSearchPrefsTypeVendorPrefItem) ? get_class($airSearchPrefsTypeVendorPrefItem) : gettype($airSearchPrefsTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVendorPref $item
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function addToVendorPref(\dgsoft\StructType\DgVendorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVendorPref) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgVendorPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \dgsoft\StructType\DgFlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightTypePref[] $flightTypePref
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        foreach ($flightTypePref as $airSearchPrefsTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeFlightTypePrefItem instanceof \dgsoft\StructType\DgFlightTypePref) {
                throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \dgsoft\StructType\DgFlightTypePref, "%s" given', is_object($airSearchPrefsTypeFlightTypePrefItem) ? get_class($airSearchPrefsTypeFlightTypePrefItem) : gettype($airSearchPrefsTypeFlightTypePrefItem)), __LINE__);
            }
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightTypePref $item
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function addToFlightTypePref(\dgsoft\StructType\DgFlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \dgsoft\StructType\DgFlightTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \dgsoft\StructType\DgFareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRestrictPref[] $fareRestrictPref
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        foreach ($fareRestrictPref as $airSearchPrefsTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeFareRestrictPrefItem instanceof \dgsoft\StructType\DgFareRestrictPref) {
                throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \dgsoft\StructType\DgFareRestrictPref, "%s" given', is_object($airSearchPrefsTypeFareRestrictPrefItem) ? get_class($airSearchPrefsTypeFareRestrictPrefItem) : gettype($airSearchPrefsTypeFareRestrictPrefItem)), __LINE__);
            }
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRestrictPref $item
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function addToFareRestrictPref(\dgsoft\StructType\DgFareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \dgsoft\StructType\DgFareRestrictPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \dgsoft\StructType\DgEquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentTypePref[] $equipPref
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setEquipPref(array $equipPref = array())
    {
        foreach ($equipPref as $airSearchPrefsTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeEquipPrefItem instanceof \dgsoft\StructType\DgEquipmentTypePref) {
                throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \dgsoft\StructType\DgEquipmentTypePref, "%s" given', is_object($airSearchPrefsTypeEquipPrefItem) ? get_class($airSearchPrefsTypeEquipPrefItem) : gettype($airSearchPrefsTypeEquipPrefItem)), __LINE__);
            }
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentTypePref $item
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function addToEquipPref(\dgsoft\StructType\DgEquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \dgsoft\StructType\DgEquipmentTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \dgsoft\StructType\DgCabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinPref[] $cabinPref
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        foreach ($cabinPref as $airSearchPrefsTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeCabinPrefItem instanceof \dgsoft\StructType\DgCabinPref) {
                throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \dgsoft\StructType\DgCabinPref, "%s" given', is_object($airSearchPrefsTypeCabinPrefItem) ? get_class($airSearchPrefsTypeCabinPrefItem) : gettype($airSearchPrefsTypeCabinPrefItem)), __LINE__);
            }
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinPref $item
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function addToCabinPref(\dgsoft\StructType\DgCabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \dgsoft\StructType\DgCabinPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \dgsoft\StructType\DgTicketDistribPref[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketDistribPref[] $ticketDistribPref
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        foreach ($ticketDistribPref as $airSearchPrefsTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeTicketDistribPrefItem instanceof \dgsoft\StructType\DgTicketDistribPref) {
                throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \dgsoft\StructType\DgTicketDistribPref, "%s" given', is_object($airSearchPrefsTypeTicketDistribPrefItem) ? get_class($airSearchPrefsTypeTicketDistribPrefItem) : gettype($airSearchPrefsTypeTicketDistribPrefItem)), __LINE__);
            }
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketDistribPref $item
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function addToTicketDistribPref(\dgsoft\StructType\DgTicketDistribPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTicketDistribPref) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \dgsoft\StructType\DgTicketDistribPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get OnTimeRate value
     * @return float|null
     */
    public function getOnTimeRate()
    {
        return $this->OnTimeRate;
    }
    /**
     * Set OnTimeRate value
     * @param float $onTimeRate
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setOnTimeRate($onTimeRate = null)
    {
        $this->OnTimeRate = $onTimeRate;
        return $this;
    }
    /**
     * Get ETicketDesired value
     * @return bool|null
     */
    public function getETicketDesired()
    {
        return $this->ETicketDesired;
    }
    /**
     * Set ETicketDesired value
     * @param bool $eTicketDesired
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setETicketDesired($eTicketDesired = false)
    {
        // validation for constraint: boolean
        if (!is_null($eTicketDesired) && !is_bool($eTicketDesired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($eTicketDesired)), __LINE__);
        }
        $this->ETicketDesired = $eTicketDesired;
        return $this;
    }
    /**
     * Get MaxStopsQuantity value
     * @return int|null
     */
    public function getMaxStopsQuantity()
    {
        return $this->MaxStopsQuantity;
    }
    /**
     * Set MaxStopsQuantity value
     * @param int $maxStopsQuantity
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setMaxStopsQuantity($maxStopsQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxStopsQuantity) && !is_numeric($maxStopsQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxStopsQuantity)), __LINE__);
        }
        $this->MaxStopsQuantity = $maxStopsQuantity;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirSearchPrefsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
