<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirReservationType extends AbstractStructBase
{
    /**
     * The OSIElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOSIelement
     */
    public $OSIElements;
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryType
     */
    public $AirItinerary;
    /**
     * The PriceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingPriceInfoType
     */
    public $PriceInfo;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The Fulfillment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFulfillment
     */
    public $Fulfillment;
    /**
     * The GroupInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgGroupInfoType
     */
    public $GroupInfo;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketingInfoType[]
     */
    public $Ticketing;
    /**
     * The Queues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue
     */
    public $Queues;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * The FlightRulePenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRuleResponseInfoType[]
     */
    public $FlightRulePenalties;
    /**
     * The FlightMiniRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMiniRuleResponseInfoType
     */
    public $FlightMiniRules;
    /**
     * The PriceMessageInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPriceMessageInfoType
     */
    public $PriceMessageInfo;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFormattedTextTextType
     */
    public $Comment;
    /**
     * The PricingOverview
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricingOverview
     */
    public $PricingOverview;
    /**
     * The PNRRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo
     */
    public $PNRRemarks;
    /**
     * The LastModified
     * @var string
     */
    public $LastModified;
    /**
     * Constructor method for AirReservationType
     * @uses DgAirReservationType::setOSIElements()
     * @uses DgAirReservationType::setAirItinerary()
     * @uses DgAirReservationType::setPriceInfo()
     * @uses DgAirReservationType::setTravelerInfo()
     * @uses DgAirReservationType::setFulfillment()
     * @uses DgAirReservationType::setGroupInfo()
     * @uses DgAirReservationType::setTicketing()
     * @uses DgAirReservationType::setQueues()
     * @uses DgAirReservationType::setBookingReferenceID()
     * @uses DgAirReservationType::setFlightRulePenalties()
     * @uses DgAirReservationType::setFlightMiniRules()
     * @uses DgAirReservationType::setPriceMessageInfo()
     * @uses DgAirReservationType::setComment()
     * @uses DgAirReservationType::setPricingOverview()
     * @uses DgAirReservationType::setPNRRemarks()
     * @uses DgAirReservationType::setLastModified()
     * @param \dgsoft\ArrayType\DgArrayOfOSIelement $oSIElements
     * @param \dgsoft\StructType\DgAirItineraryType $airItinerary
     * @param \dgsoft\StructType\DgBookingPriceInfoType $priceInfo
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @param \dgsoft\StructType\DgFulfillment $fulfillment
     * @param \dgsoft\StructType\DgGroupInfoType $groupInfo
     * @param \dgsoft\StructType\DgTicketingInfoType[] $ticketing
     * @param \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue $queues
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @param \dgsoft\StructType\DgFareRuleResponseInfoType[] $flightRulePenalties
     * @param \dgsoft\StructType\DgMiniRuleResponseInfoType $flightMiniRules
     * @param \dgsoft\StructType\DgPriceMessageInfoType $priceMessageInfo
     * @param \dgsoft\StructType\DgFormattedTextTextType $comment
     * @param \dgsoft\StructType\DgPricingOverview $pricingOverview
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks
     * @param string $lastModified
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfOSIelement $oSIElements = null, \dgsoft\StructType\DgAirItineraryType $airItinerary = null, \dgsoft\StructType\DgBookingPriceInfoType $priceInfo = null, \dgsoft\StructType\DgTravelerInfoType $travelerInfo = null, \dgsoft\StructType\DgFulfillment $fulfillment = null, \dgsoft\StructType\DgGroupInfoType $groupInfo = null, array $ticketing = array(), \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue $queues = null, array $bookingReferenceID = array(), array $flightRulePenalties = array(), \dgsoft\StructType\DgMiniRuleResponseInfoType $flightMiniRules = null, \dgsoft\StructType\DgPriceMessageInfoType $priceMessageInfo = null, \dgsoft\StructType\DgFormattedTextTextType $comment = null, \dgsoft\StructType\DgPricingOverview $pricingOverview = null, \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks = null, $lastModified = null)
    {
        $this
            ->setOSIElements($oSIElements)
            ->setAirItinerary($airItinerary)
            ->setPriceInfo($priceInfo)
            ->setTravelerInfo($travelerInfo)
            ->setFulfillment($fulfillment)
            ->setGroupInfo($groupInfo)
            ->setTicketing($ticketing)
            ->setQueues($queues)
            ->setBookingReferenceID($bookingReferenceID)
            ->setFlightRulePenalties($flightRulePenalties)
            ->setFlightMiniRules($flightMiniRules)
            ->setPriceMessageInfo($priceMessageInfo)
            ->setComment($comment)
            ->setPricingOverview($pricingOverview)
            ->setPNRRemarks($pNRRemarks)
            ->setLastModified($lastModified);
    }
    /**
     * Get OSIElements value
     * @return \dgsoft\ArrayType\DgArrayOfOSIelement|null
     */
    public function getOSIElements()
    {
        return $this->OSIElements;
    }
    /**
     * Set OSIElements value
     * @param \dgsoft\ArrayType\DgArrayOfOSIelement $oSIElements
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setOSIElements(\dgsoft\ArrayType\DgArrayOfOSIelement $oSIElements = null)
    {
        $this->OSIElements = $oSIElements;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \dgsoft\StructType\DgAirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \dgsoft\StructType\DgAirItineraryType $airItinerary
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setAirItinerary(\dgsoft\StructType\DgAirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return \dgsoft\StructType\DgBookingPriceInfoType|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param \dgsoft\StructType\DgBookingPriceInfoType $priceInfo
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setPriceInfo(\dgsoft\StructType\DgBookingPriceInfoType $priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \dgsoft\StructType\DgTravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setTravelerInfo(\dgsoft\StructType\DgTravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return \dgsoft\StructType\DgFulfillment|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param \dgsoft\StructType\DgFulfillment $fulfillment
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setFulfillment(\dgsoft\StructType\DgFulfillment $fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get GroupInfo value
     * @return \dgsoft\StructType\DgGroupInfoType|null
     */
    public function getGroupInfo()
    {
        return $this->GroupInfo;
    }
    /**
     * Set GroupInfo value
     * @param \dgsoft\StructType\DgGroupInfoType $groupInfo
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setGroupInfo(\dgsoft\StructType\DgGroupInfoType $groupInfo = null)
    {
        $this->GroupInfo = $groupInfo;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \dgsoft\StructType\DgTicketingInfoType[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketingInfoType[] $ticketing
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setTicketing(array $ticketing = array())
    {
        foreach ($ticketing as $airReservationTypeTicketingItem) {
            // validation for constraint: itemType
            if (!$airReservationTypeTicketingItem instanceof \dgsoft\StructType\DgTicketingInfoType) {
                throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of \dgsoft\StructType\DgTicketingInfoType, "%s" given', is_object($airReservationTypeTicketingItem) ? get_class($airReservationTypeTicketingItem) : gettype($airReservationTypeTicketingItem)), __LINE__);
            }
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketingInfoType $item
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function addToTicketing(\dgsoft\StructType\DgTicketingInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTicketingInfoType) {
            throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of \dgsoft\StructType\DgTicketingInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get Queues value
     * @return \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue|null
     */
    public function getQueues()
    {
        return $this->Queues;
    }
    /**
     * Set Queues value
     * @param \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue $queues
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setQueues(\dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue $queues = null)
    {
        $this->Queues = $queues;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $airReservationTypeBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$airReservationTypeBookingReferenceIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($airReservationTypeBookingReferenceIDItem) ? get_class($airReservationTypeBookingReferenceIDItem) : gettype($airReservationTypeBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function addToBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get FlightRulePenalties value
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType[]|null
     */
    public function getFlightRulePenalties()
    {
        return $this->FlightRulePenalties;
    }
    /**
     * Set FlightRulePenalties value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoType[] $flightRulePenalties
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setFlightRulePenalties(array $flightRulePenalties = array())
    {
        foreach ($flightRulePenalties as $airReservationTypeFlightRulePenaltiesItem) {
            // validation for constraint: itemType
            if (!$airReservationTypeFlightRulePenaltiesItem instanceof \dgsoft\StructType\DgFareRuleResponseInfoType) {
                throw new \InvalidArgumentException(sprintf('The FlightRulePenalties property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoType, "%s" given', is_object($airReservationTypeFlightRulePenaltiesItem) ? get_class($airReservationTypeFlightRulePenaltiesItem) : gettype($airReservationTypeFlightRulePenaltiesItem)), __LINE__);
            }
        }
        $this->FlightRulePenalties = $flightRulePenalties;
        return $this;
    }
    /**
     * Add item to FlightRulePenalties value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoType $item
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function addToFlightRulePenalties(\dgsoft\StructType\DgFareRuleResponseInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRuleResponseInfoType) {
            throw new \InvalidArgumentException(sprintf('The FlightRulePenalties property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightRulePenalties[] = $item;
        return $this;
    }
    /**
     * Get FlightMiniRules value
     * @return \dgsoft\StructType\DgMiniRuleResponseInfoType|null
     */
    public function getFlightMiniRules()
    {
        return $this->FlightMiniRules;
    }
    /**
     * Set FlightMiniRules value
     * @param \dgsoft\StructType\DgMiniRuleResponseInfoType $flightMiniRules
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setFlightMiniRules(\dgsoft\StructType\DgMiniRuleResponseInfoType $flightMiniRules = null)
    {
        $this->FlightMiniRules = $flightMiniRules;
        return $this;
    }
    /**
     * Get PriceMessageInfo value
     * @return \dgsoft\StructType\DgPriceMessageInfoType|null
     */
    public function getPriceMessageInfo()
    {
        return $this->PriceMessageInfo;
    }
    /**
     * Set PriceMessageInfo value
     * @param \dgsoft\StructType\DgPriceMessageInfoType $priceMessageInfo
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setPriceMessageInfo(\dgsoft\StructType\DgPriceMessageInfoType $priceMessageInfo = null)
    {
        $this->PriceMessageInfo = $priceMessageInfo;
        return $this;
    }
    /**
     * Get Comment value
     * @return \dgsoft\StructType\DgFormattedTextTextType|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param \dgsoft\StructType\DgFormattedTextTextType $comment
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setComment(\dgsoft\StructType\DgFormattedTextTextType $comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get PricingOverview value
     * @return \dgsoft\StructType\DgPricingOverview|null
     */
    public function getPricingOverview()
    {
        return $this->PricingOverview;
    }
    /**
     * Set PricingOverview value
     * @param \dgsoft\StructType\DgPricingOverview $pricingOverview
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setPricingOverview(\dgsoft\StructType\DgPricingOverview $pricingOverview = null)
    {
        $this->PricingOverview = $pricingOverview;
        return $this;
    }
    /**
     * Get PNRRemarks value
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo|null
     */
    public function getPNRRemarks()
    {
        return $this->PNRRemarks;
    }
    /**
     * Set PNRRemarks value
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setPNRRemarks(\dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks = null)
    {
        $this->PNRRemarks = $pNRRemarks;
        return $this;
    }
    /**
     * Get LastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->LastModified;
    }
    /**
     * Set LastModified value
     * @param string $lastModified
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModified)), __LINE__);
        }
        $this->LastModified = $lastModified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
