<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliationsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAffiliationsType extends AbstractStructBase
{
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOrganizationType[]
     */
    public $Organization;
    /**
     * The Employer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmployerType[]
     */
    public $Employer;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The TravelClub
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelClubType[]
     */
    public $TravelClub;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsuranceType[]
     */
    public $Insurance;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AffiliationsType
     * @uses DgAffiliationsType::setOrganization()
     * @uses DgAffiliationsType::setEmployer()
     * @uses DgAffiliationsType::setTravelArranger()
     * @uses DgAffiliationsType::setTravelClub()
     * @uses DgAffiliationsType::setInsurance()
     * @uses DgAffiliationsType::setTPA_Extensions()
     * @uses DgAffiliationsType::setShareSynchInd()
     * @uses DgAffiliationsType::setShareMarketInd()
     * @param \dgsoft\StructType\DgOrganizationType[] $organization
     * @param \dgsoft\StructType\DgEmployerType[] $employer
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @param \dgsoft\StructType\DgTravelClubType[] $travelClub
     * @param \dgsoft\StructType\DgInsuranceType[] $insurance
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $organization = array(), array $employer = array(), array $travelArranger = array(), array $travelClub = array(), array $insurance = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setOrganization($organization)
            ->setEmployer($employer)
            ->setTravelArranger($travelArranger)
            ->setTravelClub($travelClub)
            ->setInsurance($insurance)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Organization value
     * @return \dgsoft\StructType\DgOrganizationType[]|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOrganizationType[] $organization
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setOrganization(array $organization = array())
    {
        foreach ($organization as $affiliationsTypeOrganizationItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeOrganizationItem instanceof \dgsoft\StructType\DgOrganizationType) {
                throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of \dgsoft\StructType\DgOrganizationType, "%s" given', is_object($affiliationsTypeOrganizationItem) ? get_class($affiliationsTypeOrganizationItem) : gettype($affiliationsTypeOrganizationItem)), __LINE__);
            }
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Add item to Organization value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOrganizationType $item
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function addToOrganization(\dgsoft\StructType\DgOrganizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOrganizationType) {
            throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of \dgsoft\StructType\DgOrganizationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Organization[] = $item;
        return $this;
    }
    /**
     * Get Employer value
     * @return \dgsoft\StructType\DgEmployerType[]|null
     */
    public function getEmployer()
    {
        return $this->Employer;
    }
    /**
     * Set Employer value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployerType[] $employer
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setEmployer(array $employer = array())
    {
        foreach ($employer as $affiliationsTypeEmployerItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeEmployerItem instanceof \dgsoft\StructType\DgEmployerType) {
                throw new \InvalidArgumentException(sprintf('The Employer property can only contain items of \dgsoft\StructType\DgEmployerType, "%s" given', is_object($affiliationsTypeEmployerItem) ? get_class($affiliationsTypeEmployerItem) : gettype($affiliationsTypeEmployerItem)), __LINE__);
            }
        }
        $this->Employer = $employer;
        return $this;
    }
    /**
     * Add item to Employer value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployerType $item
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function addToEmployer(\dgsoft\StructType\DgEmployerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmployerType) {
            throw new \InvalidArgumentException(sprintf('The Employer property can only contain items of \dgsoft\StructType\DgEmployerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Employer[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \dgsoft\StructType\DgTravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $affiliationsTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeTravelArrangerItem instanceof \dgsoft\StructType\DgTravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($affiliationsTypeTravelArrangerItem) ? get_class($affiliationsTypeTravelArrangerItem) : gettype($affiliationsTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType $item
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function addToTravelArranger(\dgsoft\StructType\DgTravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get TravelClub value
     * @return \dgsoft\StructType\DgTravelClubType[]|null
     */
    public function getTravelClub()
    {
        return $this->TravelClub;
    }
    /**
     * Set TravelClub value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelClubType[] $travelClub
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setTravelClub(array $travelClub = array())
    {
        foreach ($travelClub as $affiliationsTypeTravelClubItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeTravelClubItem instanceof \dgsoft\StructType\DgTravelClubType) {
                throw new \InvalidArgumentException(sprintf('The TravelClub property can only contain items of \dgsoft\StructType\DgTravelClubType, "%s" given', is_object($affiliationsTypeTravelClubItem) ? get_class($affiliationsTypeTravelClubItem) : gettype($affiliationsTypeTravelClubItem)), __LINE__);
            }
        }
        $this->TravelClub = $travelClub;
        return $this;
    }
    /**
     * Add item to TravelClub value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelClubType $item
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function addToTravelClub(\dgsoft\StructType\DgTravelClubType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelClubType) {
            throw new \InvalidArgumentException(sprintf('The TravelClub property can only contain items of \dgsoft\StructType\DgTravelClubType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelClub[] = $item;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \dgsoft\StructType\DgInsuranceType[]|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgInsuranceType[] $insurance
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setInsurance(array $insurance = array())
    {
        foreach ($insurance as $affiliationsTypeInsuranceItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeInsuranceItem instanceof \dgsoft\StructType\DgInsuranceType) {
                throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of \dgsoft\StructType\DgInsuranceType, "%s" given', is_object($affiliationsTypeInsuranceItem) ? get_class($affiliationsTypeInsuranceItem) : gettype($affiliationsTypeInsuranceItem)), __LINE__);
            }
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Add item to Insurance value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgInsuranceType $item
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function addToInsurance(\dgsoft\StructType\DgInsuranceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgInsuranceType) {
            throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of \dgsoft\StructType\DgInsuranceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Insurance[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAffiliationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
