<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvanceSearchInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdvanceSearchInfo extends AbstractStructBase
{
    /**
     * The NumberOfRecommendation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfRecommendation;
    /**
     * The MaxEFTPercentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxEFTPercentage;
    /**
     * The IgnoreAvailability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IgnoreAvailability;
    /**
     * The MaxLayoverPerConnection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMaxLayoverPerConnection
     */
    public $MaxLayoverPerConnection;
    /**
     * The AirlineDiversity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirlineDiversityType
     */
    public $AirlineDiversity;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The ExpandedParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgExpandedParametersType
     */
    public $ExpandedParameters;
    /**
     * The ReturnMoreOvernightFlights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnMoreOvernightFlights;
    /**
     * The DuplicatedRecommedationsBehavior
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DuplicatedRecommedationsBehavior;
    /**
     * Constructor method for AdvanceSearchInfo
     * @uses DgAdvanceSearchInfo::setNumberOfRecommendation()
     * @uses DgAdvanceSearchInfo::setMaxEFTPercentage()
     * @uses DgAdvanceSearchInfo::setIgnoreAvailability()
     * @uses DgAdvanceSearchInfo::setMaxLayoverPerConnection()
     * @uses DgAdvanceSearchInfo::setAirlineDiversity()
     * @uses DgAdvanceSearchInfo::setCurrency()
     * @uses DgAdvanceSearchInfo::setExpandedParameters()
     * @uses DgAdvanceSearchInfo::setReturnMoreOvernightFlights()
     * @uses DgAdvanceSearchInfo::setDuplicatedRecommedationsBehavior()
     * @param int $numberOfRecommendation
     * @param int $maxEFTPercentage
     * @param bool $ignoreAvailability
     * @param \dgsoft\StructType\DgMaxLayoverPerConnection $maxLayoverPerConnection
     * @param \dgsoft\StructType\DgAirlineDiversityType $airlineDiversity
     * @param string $currency
     * @param \dgsoft\StructType\DgExpandedParametersType $expandedParameters
     * @param bool $returnMoreOvernightFlights
     * @param string $duplicatedRecommedationsBehavior
     */
    public function __construct($numberOfRecommendation = null, $maxEFTPercentage = null, $ignoreAvailability = null, \dgsoft\StructType\DgMaxLayoverPerConnection $maxLayoverPerConnection = null, \dgsoft\StructType\DgAirlineDiversityType $airlineDiversity = null, $currency = null, \dgsoft\StructType\DgExpandedParametersType $expandedParameters = null, $returnMoreOvernightFlights = null, $duplicatedRecommedationsBehavior = null)
    {
        $this
            ->setNumberOfRecommendation($numberOfRecommendation)
            ->setMaxEFTPercentage($maxEFTPercentage)
            ->setIgnoreAvailability($ignoreAvailability)
            ->setMaxLayoverPerConnection($maxLayoverPerConnection)
            ->setAirlineDiversity($airlineDiversity)
            ->setCurrency($currency)
            ->setExpandedParameters($expandedParameters)
            ->setReturnMoreOvernightFlights($returnMoreOvernightFlights)
            ->setDuplicatedRecommedationsBehavior($duplicatedRecommedationsBehavior);
    }
    /**
     * Get NumberOfRecommendation value
     * @return int
     */
    public function getNumberOfRecommendation()
    {
        return $this->NumberOfRecommendation;
    }
    /**
     * Set NumberOfRecommendation value
     * @param int $numberOfRecommendation
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setNumberOfRecommendation($numberOfRecommendation = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRecommendation) && !is_numeric($numberOfRecommendation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfRecommendation)), __LINE__);
        }
        $this->NumberOfRecommendation = $numberOfRecommendation;
        return $this;
    }
    /**
     * Get MaxEFTPercentage value
     * @return int
     */
    public function getMaxEFTPercentage()
    {
        return $this->MaxEFTPercentage;
    }
    /**
     * Set MaxEFTPercentage value
     * @param int $maxEFTPercentage
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setMaxEFTPercentage($maxEFTPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($maxEFTPercentage) && !is_numeric($maxEFTPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxEFTPercentage)), __LINE__);
        }
        $this->MaxEFTPercentage = $maxEFTPercentage;
        return $this;
    }
    /**
     * Get IgnoreAvailability value
     * @return bool
     */
    public function getIgnoreAvailability()
    {
        return $this->IgnoreAvailability;
    }
    /**
     * Set IgnoreAvailability value
     * @param bool $ignoreAvailability
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setIgnoreAvailability($ignoreAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreAvailability) && !is_bool($ignoreAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ignoreAvailability)), __LINE__);
        }
        $this->IgnoreAvailability = $ignoreAvailability;
        return $this;
    }
    /**
     * Get MaxLayoverPerConnection value
     * @return \dgsoft\StructType\DgMaxLayoverPerConnection|null
     */
    public function getMaxLayoverPerConnection()
    {
        return $this->MaxLayoverPerConnection;
    }
    /**
     * Set MaxLayoverPerConnection value
     * @param \dgsoft\StructType\DgMaxLayoverPerConnection $maxLayoverPerConnection
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setMaxLayoverPerConnection(\dgsoft\StructType\DgMaxLayoverPerConnection $maxLayoverPerConnection = null)
    {
        $this->MaxLayoverPerConnection = $maxLayoverPerConnection;
        return $this;
    }
    /**
     * Get AirlineDiversity value
     * @return \dgsoft\StructType\DgAirlineDiversityType|null
     */
    public function getAirlineDiversity()
    {
        return $this->AirlineDiversity;
    }
    /**
     * Set AirlineDiversity value
     * @param \dgsoft\StructType\DgAirlineDiversityType $airlineDiversity
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setAirlineDiversity(\dgsoft\StructType\DgAirlineDiversityType $airlineDiversity = null)
    {
        $this->AirlineDiversity = $airlineDiversity;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ExpandedParameters value
     * @return \dgsoft\StructType\DgExpandedParametersType|null
     */
    public function getExpandedParameters()
    {
        return $this->ExpandedParameters;
    }
    /**
     * Set ExpandedParameters value
     * @param \dgsoft\StructType\DgExpandedParametersType $expandedParameters
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setExpandedParameters(\dgsoft\StructType\DgExpandedParametersType $expandedParameters = null)
    {
        $this->ExpandedParameters = $expandedParameters;
        return $this;
    }
    /**
     * Get ReturnMoreOvernightFlights value
     * @return bool|null
     */
    public function getReturnMoreOvernightFlights()
    {
        return $this->ReturnMoreOvernightFlights;
    }
    /**
     * Set ReturnMoreOvernightFlights value
     * @param bool $returnMoreOvernightFlights
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setReturnMoreOvernightFlights($returnMoreOvernightFlights = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnMoreOvernightFlights) && !is_bool($returnMoreOvernightFlights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnMoreOvernightFlights)), __LINE__);
        }
        $this->ReturnMoreOvernightFlights = $returnMoreOvernightFlights;
        return $this;
    }
    /**
     * Get DuplicatedRecommedationsBehavior value
     * @return string|null
     */
    public function getDuplicatedRecommedationsBehavior()
    {
        return $this->DuplicatedRecommedationsBehavior;
    }
    /**
     * Set DuplicatedRecommedationsBehavior value
     * @uses \dgsoft\EnumType\DgDuplicatedRecommedationsBehaviorEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgDuplicatedRecommedationsBehaviorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duplicatedRecommedationsBehavior
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public function setDuplicatedRecommedationsBehavior($duplicatedRecommedationsBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDuplicatedRecommedationsBehaviorEnum::valueIsValid($duplicatedRecommedationsBehavior)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $duplicatedRecommedationsBehavior, implode(', ', \dgsoft\EnumType\DgDuplicatedRecommedationsBehaviorEnum::getValidValues())), __LINE__);
        }
        $this->DuplicatedRecommedationsBehavior = $duplicatedRecommedationsBehavior;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
