<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvTicketing StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdvTicketing extends AbstractStructBase
{
    /**
     * The FromResTimeOfDay
     * @var string
     */
    public $FromResTimeOfDay;
    /**
     * The FromResPeriod
     * @var string
     */
    public $FromResPeriod;
    /**
     * The FromResUnit
     * @var string
     */
    public $FromResUnit;
    /**
     * The FromDepartTimeOfDay
     * @var string
     */
    public $FromDepartTimeOfDay;
    /**
     * The FromDepartPeriod
     * @var string
     */
    public $FromDepartPeriod;
    /**
     * The FromDepartUnit
     * @var string
     */
    public $FromDepartUnit;
    /**
     * Constructor method for AdvTicketing
     * @uses DgAdvTicketing::setFromResTimeOfDay()
     * @uses DgAdvTicketing::setFromResPeriod()
     * @uses DgAdvTicketing::setFromResUnit()
     * @uses DgAdvTicketing::setFromDepartTimeOfDay()
     * @uses DgAdvTicketing::setFromDepartPeriod()
     * @uses DgAdvTicketing::setFromDepartUnit()
     * @param string $fromResTimeOfDay
     * @param string $fromResPeriod
     * @param string $fromResUnit
     * @param string $fromDepartTimeOfDay
     * @param string $fromDepartPeriod
     * @param string $fromDepartUnit
     */
    public function __construct($fromResTimeOfDay = null, $fromResPeriod = null, $fromResUnit = null, $fromDepartTimeOfDay = null, $fromDepartPeriod = null, $fromDepartUnit = null)
    {
        $this
            ->setFromResTimeOfDay($fromResTimeOfDay)
            ->setFromResPeriod($fromResPeriod)
            ->setFromResUnit($fromResUnit)
            ->setFromDepartTimeOfDay($fromDepartTimeOfDay)
            ->setFromDepartPeriod($fromDepartPeriod)
            ->setFromDepartUnit($fromDepartUnit);
    }
    /**
     * Get FromResTimeOfDay value
     * @return string|null
     */
    public function getFromResTimeOfDay()
    {
        return $this->FromResTimeOfDay;
    }
    /**
     * Set FromResTimeOfDay value
     * @param string $fromResTimeOfDay
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public function setFromResTimeOfDay($fromResTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($fromResTimeOfDay) && !is_string($fromResTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromResTimeOfDay)), __LINE__);
        }
        $this->FromResTimeOfDay = $fromResTimeOfDay;
        return $this;
    }
    /**
     * Get FromResPeriod value
     * @return string|null
     */
    public function getFromResPeriod()
    {
        return $this->FromResPeriod;
    }
    /**
     * Set FromResPeriod value
     * @param string $fromResPeriod
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public function setFromResPeriod($fromResPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($fromResPeriod) && !is_string($fromResPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromResPeriod)), __LINE__);
        }
        $this->FromResPeriod = $fromResPeriod;
        return $this;
    }
    /**
     * Get FromResUnit value
     * @return string|null
     */
    public function getFromResUnit()
    {
        return $this->FromResUnit;
    }
    /**
     * Set FromResUnit value
     * @uses \dgsoft\EnumType\DgStayUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgStayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fromResUnit
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public function setFromResUnit($fromResUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgStayUnitType::valueIsValid($fromResUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fromResUnit, implode(', ', \dgsoft\EnumType\DgStayUnitType::getValidValues())), __LINE__);
        }
        $this->FromResUnit = $fromResUnit;
        return $this;
    }
    /**
     * Get FromDepartTimeOfDay value
     * @return string|null
     */
    public function getFromDepartTimeOfDay()
    {
        return $this->FromDepartTimeOfDay;
    }
    /**
     * Set FromDepartTimeOfDay value
     * @param string $fromDepartTimeOfDay
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public function setFromDepartTimeOfDay($fromDepartTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($fromDepartTimeOfDay) && !is_string($fromDepartTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDepartTimeOfDay)), __LINE__);
        }
        $this->FromDepartTimeOfDay = $fromDepartTimeOfDay;
        return $this;
    }
    /**
     * Get FromDepartPeriod value
     * @return string|null
     */
    public function getFromDepartPeriod()
    {
        return $this->FromDepartPeriod;
    }
    /**
     * Set FromDepartPeriod value
     * @param string $fromDepartPeriod
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public function setFromDepartPeriod($fromDepartPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($fromDepartPeriod) && !is_string($fromDepartPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDepartPeriod)), __LINE__);
        }
        $this->FromDepartPeriod = $fromDepartPeriod;
        return $this;
    }
    /**
     * Get FromDepartUnit value
     * @return string|null
     */
    public function getFromDepartUnit()
    {
        return $this->FromDepartUnit;
    }
    /**
     * Set FromDepartUnit value
     * @uses \dgsoft\EnumType\DgStayUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgStayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fromDepartUnit
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public function setFromDepartUnit($fromDepartUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgStayUnitType::valueIsValid($fromDepartUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fromDepartUnit, implode(', ', \dgsoft\EnumType\DgStayUnitType::getValidValues())), __LINE__);
        }
        $this->FromDepartUnit = $fromDepartUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdvTicketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
