<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvReservation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdvReservation extends AbstractStructBase
{
    /**
     * The LatestTimeOfDay
     * @var string
     */
    public $LatestTimeOfDay;
    /**
     * The LatestPeriod
     * @var string
     */
    public $LatestPeriod;
    /**
     * The LatestUnit
     * @var string
     */
    public $LatestUnit;
    /**
     * Constructor method for AdvReservation
     * @uses DgAdvReservation::setLatestTimeOfDay()
     * @uses DgAdvReservation::setLatestPeriod()
     * @uses DgAdvReservation::setLatestUnit()
     * @param string $latestTimeOfDay
     * @param string $latestPeriod
     * @param string $latestUnit
     */
    public function __construct($latestTimeOfDay = null, $latestPeriod = null, $latestUnit = null)
    {
        $this
            ->setLatestTimeOfDay($latestTimeOfDay)
            ->setLatestPeriod($latestPeriod)
            ->setLatestUnit($latestUnit);
    }
    /**
     * Get LatestTimeOfDay value
     * @return string|null
     */
    public function getLatestTimeOfDay()
    {
        return $this->LatestTimeOfDay;
    }
    /**
     * Set LatestTimeOfDay value
     * @param string $latestTimeOfDay
     * @return \dgsoft\StructType\DgAdvReservation
     */
    public function setLatestTimeOfDay($latestTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($latestTimeOfDay) && !is_string($latestTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latestTimeOfDay)), __LINE__);
        }
        $this->LatestTimeOfDay = $latestTimeOfDay;
        return $this;
    }
    /**
     * Get LatestPeriod value
     * @return string|null
     */
    public function getLatestPeriod()
    {
        return $this->LatestPeriod;
    }
    /**
     * Set LatestPeriod value
     * @param string $latestPeriod
     * @return \dgsoft\StructType\DgAdvReservation
     */
    public function setLatestPeriod($latestPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($latestPeriod) && !is_string($latestPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latestPeriod)), __LINE__);
        }
        $this->LatestPeriod = $latestPeriod;
        return $this;
    }
    /**
     * Get LatestUnit value
     * @return string|null
     */
    public function getLatestUnit()
    {
        return $this->LatestUnit;
    }
    /**
     * Set LatestUnit value
     * @uses \dgsoft\EnumType\DgStayUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgStayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $latestUnit
     * @return \dgsoft\StructType\DgAdvReservation
     */
    public function setLatestUnit($latestUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgStayUnitType::valueIsValid($latestUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $latestUnit, implode(', ', \dgsoft\EnumType\DgStayUnitType::getValidValues())), __LINE__);
        }
        $this->LatestUnit = $latestUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdvReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
